/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.domain;

import com.codingapi.springboot.flow.build.SchemaReader;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowRelation;
import com.codingapi.springboot.flow.serializable.FlowWorkSerializable;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.flow.utils.IDGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class FlowWork {
    private long id;
    private String title;
    private String description;
    private IFlowOperator createUser;
    private long createTime;
    private long updateTime;
    private boolean enable;
    private int postponedMax;
    private List<FlowNode> nodes;
    private List<FlowRelation> relations;
    private String schema;

    public FlowWork(IFlowOperator createUser) {
        this.createUser = createUser;
        this.createTime = System.currentTimeMillis();
        this.updateTime = System.currentTimeMillis();
        this.nodes = new ArrayList<FlowNode>();
        this.relations = new ArrayList<FlowRelation>();
        this.enable = false;
        this.postponedMax = 1;
    }

    public FlowWork copy() {
        String newId;
        if (!StringUtils.hasLength((String)this.schema)) {
            throw new IllegalArgumentException("schema is empty");
        }
        String schema = this.getSchema();
        for (FlowNode flowNode : this.getNodes()) {
            newId = IDGenerator.generate();
            schema = schema.replaceAll(flowNode.getId(), newId);
        }
        for (FlowRelation relation : this.getRelations()) {
            newId = IDGenerator.generate();
            schema = schema.replaceAll(relation.getId(), newId);
        }
        FlowWork flowWork = new FlowWork(this.createUser);
        flowWork.setDescription(this.getDescription());
        flowWork.setTitle(this.getTitle());
        flowWork.setPostponedMax(this.getPostponedMax());
        flowWork.schema(schema);
        return flowWork;
    }

    public FlowWork(String title, String description, int postponedMax, IFlowOperator createUser) {
        this.title = title;
        this.description = description;
        this.postponedMax = postponedMax;
        this.createUser = createUser;
        this.createTime = System.currentTimeMillis();
        this.updateTime = System.currentTimeMillis();
        this.nodes = new ArrayList<FlowNode>();
        this.relations = new ArrayList<FlowRelation>();
        this.enable = false;
    }

    public void verify() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes is empty");
        }
        if (this.relations == null || this.relations.isEmpty()) {
            throw new IllegalArgumentException("relations is empty");
        }
        if (!StringUtils.hasLength((String)this.title)) {
            throw new IllegalArgumentException("title is empty");
        }
        this.verifyNodes();
        this.verifyRelations();
        this.checkRelation();
    }

    private void checkRelation() {
        FlowNode startNode = this.getNodeByCode("start");
        if (startNode == null) {
            throw new IllegalArgumentException("start node is not exist");
        }
        FlowNode overNode = this.getNodeByCode("over");
        if (overNode == null) {
            throw new IllegalArgumentException("over node is not exist");
        }
        ArrayList<String> sourceCodes = new ArrayList<String>();
        ArrayList<String> targetCodes = new ArrayList<String>();
        for (FlowRelation relation : this.relations) {
            sourceCodes.add(relation.getSource().getCode());
            targetCodes.add(relation.getTarget().getCode());
        }
        if (!sourceCodes.contains("start")) {
            throw new IllegalArgumentException("start node relation is not exist");
        }
        if (!targetCodes.contains("over")) {
            throw new IllegalArgumentException("over node relation is not exist");
        }
    }

    private void verifyNodes() {
        ArrayList<String> nodeCodes = new ArrayList<String>();
        for (FlowNode node : this.nodes) {
            node.verify();
            if (nodeCodes.contains(node.getCode())) {
                throw new IllegalArgumentException("node code is exist");
            }
            nodeCodes.add(node.getCode());
        }
    }

    private void verifyRelations() {
        for (FlowRelation relation : this.relations) {
            relation.verify();
            relation.verifyNodes(this.nodes);
        }
    }

    public FlowWorkSerializable toSerializable() {
        return new FlowWorkSerializable(this.id, this.title, this.description, this.createUser.getUserId(), this.createTime, this.updateTime, this.enable, this.postponedMax, this.nodes.stream().map(FlowNode::toSerializable).collect(Collectors.toCollection(ArrayList::new)), this.relations.stream().map(FlowRelation::toSerializable).collect(Collectors.toCollection(ArrayList::new)));
    }

    public void schema(String schema) {
        SchemaReader schemaReader = new SchemaReader(schema);
        this.relations = schemaReader.getFlowRelations();
        this.nodes = schemaReader.getFlowNodes();
        this.schema = schema;
        this.verify();
        this.updateTime = System.currentTimeMillis();
    }

    public void addNode(FlowNode node) {
        List<String> codes = this.nodes.stream().map(FlowNode::getCode).toList();
        if (codes.contains(node.getCode())) {
            throw new IllegalArgumentException("node code is exist");
        }
        this.nodes.add(node);
        this.updateTime = System.currentTimeMillis();
    }

    public void addRelation(FlowRelation relation) {
        this.relations.add(relation);
        this.updateTime = System.currentTimeMillis();
    }

    public FlowNode getNodeByCode(String code) {
        for (FlowNode node : this.nodes) {
            if (!node.getCode().equals(code)) continue;
            return node;
        }
        return null;
    }

    public FlowNode getStartNode() {
        return this.getNodeByCode("start");
    }

    public boolean hasBackRelation() {
        return this.relations.stream().anyMatch(FlowRelation::isBack);
    }

    public void enableValidate() {
        if (!this.isEnable()) {
            throw new IllegalArgumentException("flow work is disable");
        }
    }

    public void enable() {
        this.verify();
        this.enable = true;
    }

    public void disbale() {
        this.enable = false;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public IFlowOperator getCreateUser() {
        return this.createUser;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public int getPostponedMax() {
        return this.postponedMax;
    }

    @Generated
    public List<FlowNode> getNodes() {
        return this.nodes;
    }

    @Generated
    public List<FlowRelation> getRelations() {
        return this.relations;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public FlowWork(long id, String title, String description, IFlowOperator createUser, long createTime, long updateTime, boolean enable, int postponedMax, List<FlowNode> nodes, List<FlowRelation> relations, String schema) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.createUser = createUser;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.enable = enable;
        this.postponedMax = postponedMax;
        this.nodes = nodes;
        this.relations = relations;
        this.schema = schema;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setPostponedMax(int postponedMax) {
        this.postponedMax = postponedMax;
    }
}

