/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.record;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.em.FlowStatus;
import com.codingapi.springboot.flow.em.FlowType;
import com.codingapi.springboot.flow.user.IFlowOperator;
import lombok.Generated;

public class FlowRecord {
    private long id;
    private long preId;
    private long workId;
    private String processId;
    private String nodeCode;
    private String title;
    private long currentOperatorId;
    private FlowType flowType;
    private FlowSourceDirection flowSourceDirection;
    private long createTime;
    private long updateTime;
    private long finishTime;
    private long timeoutTime;
    private int postponedCount;
    private long createOperatorId;
    private Opinion opinion;
    private FlowStatus flowStatus;
    private String errMessage;
    private String bindClass;
    private long snapshotId;
    private boolean read;
    private boolean interfere;
    private long interferedOperatorId;
    private long readTime;

    public void postponedTime(int postponedMax, long time) {
        if (this.postponedCount >= postponedMax) {
            throw new IllegalArgumentException("postponed count is max");
        }
        this.read();
        if (this.timeoutTime == 0L) {
            this.timeoutTime = System.currentTimeMillis();
        }
        this.timeoutTime += time;
        ++this.postponedCount;
        this.updateTime = System.currentTimeMillis();
    }

    public boolean isInitiated() {
        return this.preId == 0L && this.nodeCode.equals("start");
    }

    public void read() {
        this.read = true;
        this.readTime = System.currentTimeMillis();
    }

    public boolean isUnRead() {
        return !this.read;
    }

    public void update(Opinion opinion) {
        this.read();
        this.opinion = opinion;
        this.updateTime = System.currentTimeMillis();
    }

    public void submitStateVerify() {
        if (this.flowStatus == FlowStatus.FINISH) {
            throw new IllegalArgumentException("flow is finish");
        }
        if (this.flowType == FlowType.DONE) {
            throw new IllegalArgumentException("flow is done");
        }
    }

    public void submitRecord(IFlowOperator flowOperator, BindDataSnapshot snapshot, Opinion opinion, FlowSourceDirection flowSourceDirection) {
        if (!flowOperator.isFlowManager()) {
            if (flowOperator.getUserId() != this.currentOperatorId) {
                throw new IllegalArgumentException("current operator is not match");
            }
        } else {
            this.interferedOperatorId = this.currentOperatorId;
            this.currentOperatorId = flowOperator.getUserId();
            this.interfere = true;
        }
        this.read();
        this.flowSourceDirection = flowSourceDirection;
        this.flowType = FlowType.DONE;
        this.updateTime = System.currentTimeMillis();
        this.snapshotId = snapshot.getId();
        this.bindClass = snapshot.getClazzName();
        this.opinion = opinion;
    }

    public void transfer(IFlowOperator flowOperator, BindDataSnapshot snapshot, Opinion opinion) {
        if (flowOperator.getUserId() != this.currentOperatorId) {
            throw new IllegalArgumentException("current operator is not match");
        }
        this.read();
        this.flowSourceDirection = FlowSourceDirection.TRANSFER;
        this.flowType = FlowType.TRANSFER;
        this.updateTime = System.currentTimeMillis();
        this.snapshotId = snapshot.getId();
        this.bindClass = snapshot.getClazzName();
        this.opinion = opinion;
    }

    public void transferToTodo(String title, IFlowOperator operator) {
        this.id = 0L;
        this.flowType = FlowType.TODO;
        this.flowStatus = FlowStatus.RUNNING;
        this.postponedCount = 0;
        this.updateTime = 0L;
        this.readTime = 0L;
        this.read = false;
        this.title = title;
        this.opinion = null;
        this.flowSourceDirection = null;
        this.interfere = false;
        this.interferedOperatorId = 0L;
        this.currentOperatorId = operator.getUserId();
    }

    public void autoPass(IFlowOperator flowOperator, BindDataSnapshot snapshot) {
        this.read();
        this.flowSourceDirection = FlowSourceDirection.PASS;
        this.currentOperatorId = flowOperator.getUserId();
        this.flowType = FlowType.DONE;
        this.updateTime = System.currentTimeMillis();
        this.snapshotId = snapshot.getId();
        this.bindClass = snapshot.getClazzName();
        this.opinion = Opinion.unSignAutoSuccess();
    }

    public void finish() {
        this.flowStatus = FlowStatus.FINISH;
        this.finishTime = System.currentTimeMillis();
    }

    public boolean isDone() {
        return this.flowType == FlowType.DONE;
    }

    public boolean isFinish() {
        return this.flowStatus == FlowStatus.FINISH;
    }

    public boolean isTodo() {
        return this.flowType == FlowType.TODO && this.flowStatus == FlowStatus.RUNNING;
    }

    public boolean isTransfer() {
        return this.flowType == FlowType.TRANSFER;
    }

    public boolean isPass() {
        return this.opinion != null && this.opinion.isSuccess() && this.isDone();
    }

    public void matcherOperator(IFlowOperator currentOperator) {
        if (!this.isOperator(currentOperator)) {
            throw new IllegalArgumentException("current operator is not match");
        }
    }

    public boolean isOperator(IFlowOperator operator) {
        return this.currentOperatorId == operator.getUserId();
    }

    public void recall() {
        this.flowType = FlowType.TODO;
        this.updateTime = System.currentTimeMillis();
    }

    public FlowRecord copy() {
        FlowRecord record = new FlowRecord();
        record.setId(this.id);
        record.setPostponedCount(this.postponedCount);
        record.setPreId(this.preId);
        record.setWorkId(this.workId);
        record.setProcessId(this.processId);
        record.setNodeCode(this.nodeCode);
        record.setTitle(this.title);
        record.setCurrentOperatorId(this.currentOperatorId);
        record.setFlowType(this.flowType);
        record.setFlowSourceDirection(this.flowSourceDirection);
        record.setCreateTime(this.createTime);
        record.setUpdateTime(this.updateTime);
        record.setFinishTime(this.finishTime);
        record.setTimeoutTime(this.timeoutTime);
        record.setCreateOperatorId(this.createOperatorId);
        record.setOpinion(this.opinion);
        record.setFlowStatus(this.flowStatus);
        record.setErrMessage(this.errMessage);
        record.setBindClass(this.bindClass);
        record.setSnapshotId(this.snapshotId);
        record.setRead(this.read);
        record.setInterfere(this.interfere);
        record.setInterferedOperatorId(this.interferedOperatorId);
        record.setReadTime(this.readTime);
        return record;
    }

    public boolean isTimeout() {
        if (this.timeoutTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() > this.timeoutTime;
    }

    public boolean isPostponed() {
        return this.postponedCount > 0;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setPreId(long preId) {
        this.preId = preId;
    }

    @Generated
    public void setWorkId(long workId) {
        this.workId = workId;
    }

    @Generated
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Generated
    public void setNodeCode(String nodeCode) {
        this.nodeCode = nodeCode;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setCurrentOperatorId(long currentOperatorId) {
        this.currentOperatorId = currentOperatorId;
    }

    @Generated
    public void setFlowType(FlowType flowType) {
        this.flowType = flowType;
    }

    @Generated
    public void setFlowSourceDirection(FlowSourceDirection flowSourceDirection) {
        this.flowSourceDirection = flowSourceDirection;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    @Generated
    public void setTimeoutTime(long timeoutTime) {
        this.timeoutTime = timeoutTime;
    }

    @Generated
    public void setPostponedCount(int postponedCount) {
        this.postponedCount = postponedCount;
    }

    @Generated
    public void setCreateOperatorId(long createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    @Generated
    public void setOpinion(Opinion opinion) {
        this.opinion = opinion;
    }

    @Generated
    public void setFlowStatus(FlowStatus flowStatus) {
        this.flowStatus = flowStatus;
    }

    @Generated
    public void setErrMessage(String errMessage) {
        this.errMessage = errMessage;
    }

    @Generated
    public void setBindClass(String bindClass) {
        this.bindClass = bindClass;
    }

    @Generated
    public void setSnapshotId(long snapshotId) {
        this.snapshotId = snapshotId;
    }

    @Generated
    public void setRead(boolean read) {
        this.read = read;
    }

    @Generated
    public void setInterfere(boolean interfere) {
        this.interfere = interfere;
    }

    @Generated
    public void setInterferedOperatorId(long interferedOperatorId) {
        this.interferedOperatorId = interferedOperatorId;
    }

    @Generated
    public void setReadTime(long readTime) {
        this.readTime = readTime;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public long getPreId() {
        return this.preId;
    }

    @Generated
    public long getWorkId() {
        return this.workId;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public String getNodeCode() {
        return this.nodeCode;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public long getCurrentOperatorId() {
        return this.currentOperatorId;
    }

    @Generated
    public FlowType getFlowType() {
        return this.flowType;
    }

    @Generated
    public FlowSourceDirection getFlowSourceDirection() {
        return this.flowSourceDirection;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getFinishTime() {
        return this.finishTime;
    }

    @Generated
    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    @Generated
    public int getPostponedCount() {
        return this.postponedCount;
    }

    @Generated
    public long getCreateOperatorId() {
        return this.createOperatorId;
    }

    @Generated
    public Opinion getOpinion() {
        return this.opinion;
    }

    @Generated
    public FlowStatus getFlowStatus() {
        return this.flowStatus;
    }

    @Generated
    public String getErrMessage() {
        return this.errMessage;
    }

    @Generated
    public String getBindClass() {
        return this.bindClass;
    }

    @Generated
    public long getSnapshotId() {
        return this.snapshotId;
    }

    @Generated
    public boolean isRead() {
        return this.read;
    }

    @Generated
    public boolean isInterfere() {
        return this.interfere;
    }

    @Generated
    public long getInterferedOperatorId() {
        return this.interferedOperatorId;
    }

    @Generated
    public long getReadTime() {
        return this.readTime;
    }

    @Generated
    public String toString() {
        return "FlowRecord(id=" + this.getId() + ", preId=" + this.getPreId() + ", workId=" + this.getWorkId() + ", processId=" + this.getProcessId() + ", nodeCode=" + this.getNodeCode() + ", title=" + this.getTitle() + ", currentOperatorId=" + this.getCurrentOperatorId() + ", flowType=" + String.valueOf((Object)this.getFlowType()) + ", flowSourceDirection=" + String.valueOf((Object)this.getFlowSourceDirection()) + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", finishTime=" + this.getFinishTime() + ", timeoutTime=" + this.getTimeoutTime() + ", postponedCount=" + this.getPostponedCount() + ", createOperatorId=" + this.getCreateOperatorId() + ", opinion=" + String.valueOf(this.getOpinion()) + ", flowStatus=" + String.valueOf((Object)this.getFlowStatus()) + ", errMessage=" + this.getErrMessage() + ", bindClass=" + this.getBindClass() + ", snapshotId=" + this.getSnapshotId() + ", read=" + this.isRead() + ", interfere=" + this.isInterfere() + ", interferedOperatorId=" + this.getInterferedOperatorId() + ", readTime=" + this.getReadTime() + ")";
    }
}

