/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.content.FlowSession;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.pojo.FlowDetail;
import com.codingapi.springboot.flow.record.FlowBackup;
import com.codingapi.springboot.flow.record.FlowProcess;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBackupRepository;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowDirectionService;
import com.codingapi.springboot.flow.service.FlowRecordBuilderService;
import com.codingapi.springboot.flow.service.FlowRecordService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowService {
    private final FlowWorkRepository flowWorkRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowBindDataRepository flowBindDataRepository;
    private final FlowOperatorRepository flowOperatorRepository;
    private final FlowProcessRepository flowProcessRepository;
    private final FlowBackupRepository flowBackupRepository;

    public FlowDetail detail(long recordId) {
        return this.detail(recordId, null);
    }

    public void postponed(long recordId, IFlowOperator currentOperator, long time) {
        FlowRecordService flowRecordService = new FlowRecordService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordService.loadFlowRecord();
        flowRecordService.verifyFlowRecordSubmitState();
        flowRecordService.verifyFlowRecordCurrentOperator();
        flowRecordService.loadFlowWork();
        flowRecordService.verifyFlowRecordNotFinish();
        flowRecordService.verifyFlowRecordNotDone();
        FlowRecord flowRecord = flowRecordService.getFlowRecord();
        FlowWork flowWork = flowRecordService.getFlowWork();
        flowRecord.postponedTime(flowWork.getPostponedMax(), time);
        this.flowRecordRepository.update(flowRecord);
    }

    public void urge(long recordId, IFlowOperator currentOperator) {
        FlowRecordService flowRecordService = new FlowRecordService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordService.loadFlowRecord();
        flowRecordService.loadFlowWork();
        flowRecordService.verifyFlowRecordIsDone();
        FlowRecord flowRecord = flowRecordService.getFlowRecord();
        FlowWork flowWork = flowRecordService.getFlowWork();
        List<FlowRecord> todoRecords = this.flowRecordRepository.findTodoFlowRecordByProcessId(flowRecord.getProcessId());
        for (FlowRecord record : todoRecords) {
            IFlowOperator pushOperator = this.flowOperatorRepository.getFlowOperatorById(record.getCurrentOperatorId());
            EventPusher.push((IEvent)new FlowApprovalEvent(8, record, pushOperator, flowWork));
        }
    }

    public FlowDetail detail(long recordId, IFlowOperator currentOperator) {
        FlowRecordService flowRecordService = new FlowRecordService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordService.loadFlowRecord();
        flowRecordService.setFlowRecordRead();
        flowRecordService.loadFlowWork();
        FlowRecord flowRecord = flowRecordService.getFlowRecord();
        FlowWork flowWork = flowRecordService.getFlowWork();
        BindDataSnapshot snapshot = this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        List<FlowRecord> flowRecords = this.flowRecordRepository.findFlowRecordByProcessId(flowRecord.getProcessId());
        ArrayList<Long> operatorIds = new ArrayList<Long>();
        for (FlowRecord record : flowRecords) {
            if (!operatorIds.contains(record.getCurrentOperatorId())) {
                operatorIds.add(record.getCurrentOperatorId());
            }
            if (operatorIds.contains(record.getCreateOperatorId())) continue;
            operatorIds.add(record.getCreateOperatorId());
        }
        List<? extends IFlowOperator> operators = this.flowOperatorRepository.findByIds(operatorIds);
        return new FlowDetail(flowRecord, snapshot, flowWork, flowRecords, operators);
    }

    public void interfere(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        if (!currentOperator.isFlowManager()) {
            throw new IllegalArgumentException("current operator is not flow manager");
        }
        this.submitFlow(recordId, currentOperator, bindData, opinion);
    }

    public void transfer(long recordId, IFlowOperator currentOperator, IFlowOperator targetOperator, IBindData bindData, String advice) {
        FlowRecordService flowRecordService = new FlowRecordService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordService.loadFlowRecord();
        flowRecordService.verifyFlowRecordSubmitState();
        flowRecordService.verifyFlowRecordCurrentOperator();
        flowRecordService.verifyTargetOperatorIsNotCurrentOperator(targetOperator);
        flowRecordService.loadFlowWork();
        flowRecordService.loadFlowNode();
        flowRecordService.verifyFlowRecordIsTodo();
        FlowRecord flowRecord = flowRecordService.getFlowRecord();
        FlowWork flowWork = flowRecordService.getFlowWork();
        FlowNode flowNode = flowRecordService.getFlowNode();
        BindDataSnapshot snapshot = new BindDataSnapshot(bindData);
        this.flowBindDataRepository.save(snapshot);
        Opinion opinion = Opinion.transfer(advice);
        flowRecord.transfer(currentOperator, snapshot, opinion);
        this.flowRecordRepository.update(flowRecord);
        IFlowOperator createOperator = this.flowOperatorRepository.getFlowOperatorById(flowRecord.getCreateOperatorId());
        List<FlowRecord> historyRecords = this.flowRecordRepository.findFlowRecordByPreId(flowRecord.getPreId());
        FlowSession content = new FlowSession(flowWork, flowNode, createOperator, targetOperator, snapshot.toBindData(), opinion, historyRecords);
        String generateTitle = flowNode.generateTitle(content);
        FlowRecord transferRecord = flowRecord.copy();
        transferRecord.transferToTodo(generateTitle, targetOperator);
        this.flowRecordRepository.save(List.of(transferRecord));
        EventPusher.push((IEvent)new FlowApprovalEvent(4, flowRecord, currentOperator, flowWork));
        EventPusher.push((IEvent)new FlowApprovalEvent(7, transferRecord, targetOperator, flowWork));
    }

    public void save(long recordId, IFlowOperator currentOperator, IBindData bindData, String advice) {
        FlowRecordService flowRecordService = new FlowRecordService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordService.loadFlowRecord();
        flowRecordService.verifyFlowRecordSubmitState();
        flowRecordService.verifyFlowRecordCurrentOperator();
        flowRecordService.loadFlowWork();
        flowRecordService.loadFlowNode();
        flowRecordService.verifyFlowNodeEditableState(false);
        Opinion opinion = Opinion.save(advice);
        FlowRecord flowRecord = flowRecordService.getFlowRecord();
        BindDataSnapshot snapshot = new BindDataSnapshot(flowRecord.getSnapshotId(), bindData);
        this.flowBindDataRepository.update(snapshot);
        flowRecord.setOpinion(opinion);
        flowRecordService.flowRecordRepository.update(flowRecord);
    }

    public void startFlow(long workId, IFlowOperator operator, IBindData bindData, String advice) {
        FlowWork flowWork = this.flowWorkRepository.getFlowWorkById(workId);
        if (flowWork == null) {
            throw new IllegalArgumentException("flow work not found");
        }
        flowWork.verify();
        flowWork.enableValidate();
        FlowBackup flowBackup = this.flowBackupRepository.getFlowBackupByWorkIdAndVersion(flowWork.getId(), flowWork.getUpdateTime());
        if (flowBackup == null) {
            flowBackup = this.flowBackupRepository.backup(flowWork);
        }
        FlowProcess flowProcess = new FlowProcess(flowBackup.getId(), operator);
        this.flowProcessRepository.save(flowProcess);
        BindDataSnapshot snapshot = new BindDataSnapshot(bindData);
        this.flowBindDataRepository.save(snapshot);
        String processId = flowProcess.getProcessId();
        Opinion opinion = Opinion.pass(advice);
        FlowNode start = flowWork.getStartNode();
        if (start == null) {
            throw new IllegalArgumentException("start node not found");
        }
        long preId = 0L;
        FlowRecordBuilderService flowRecordBuilderService = new FlowRecordBuilderService(this.flowOperatorRepository, this.flowRecordRepository, snapshot, opinion, operator, operator, new ArrayList<FlowRecord>(), flowWork, processId, preId);
        List<FlowRecord> records = flowRecordBuilderService.createRecord(start, operator);
        if (records.isEmpty()) {
            throw new IllegalArgumentException("flow record not found");
        }
        this.flowRecordRepository.save(records);
        for (FlowRecord record : records) {
            EventPusher.push((IEvent)new FlowApprovalEvent(1, record, operator, flowWork));
            EventPusher.push((IEvent)new FlowApprovalEvent(7, record, operator, flowWork));
        }
    }

    public void submitFlow(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        boolean next;
        FlowRecordService flowRecordService = new FlowRecordService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordService.loadFlowRecord();
        flowRecordService.verifyFlowRecordSubmitState();
        flowRecordService.verifyFlowRecordCurrentOperator();
        flowRecordService.loadFlowWork();
        flowRecordService.loadFlowNode();
        flowRecordService.verifyChildrenRecordsIsEmpty();
        FlowRecord flowRecord = flowRecordService.getFlowRecord();
        FlowNode flowNode = flowRecordService.getFlowNode();
        FlowWork flowWork = flowRecordService.getFlowWork();
        BindDataSnapshot snapshot = null;
        if (flowNode.isEditable()) {
            snapshot = new BindDataSnapshot(bindData);
            this.flowBindDataRepository.save(snapshot);
        } else {
            snapshot = this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        }
        FlowDirectionService flowDirectionService = new FlowDirectionService(flowRecordService.getFlowNode(), flowRecordService.getFlowWork(), opinion);
        flowDirectionService.loadFlowSourceDirection();
        flowDirectionService.verifyFlowSourceDirection();
        FlowSourceDirection flowSourceDirection = flowDirectionService.getFlowSourceDirection();
        flowRecord.submitRecord(currentOperator, snapshot, opinion, flowSourceDirection);
        this.flowRecordRepository.update(flowRecord);
        List<FlowRecord> historyRecords = this.flowRecordRepository.findFlowRecordByPreId(flowRecord.getPreId());
        flowDirectionService.bindHistoryRecords(historyRecords);
        if (flowNode.isSign() && (next = flowDirectionService.hasCurrentFlowNodeIsDone())) {
            return;
        }
        if (flowNode.isUnSign()) {
            for (FlowRecord record : historyRecords) {
                if (!record.isTodo() || record.getId() == flowRecord.getId()) continue;
                record.autoPass(currentOperator, snapshot);
                this.flowRecordRepository.update(flowRecord);
            }
        }
        flowSourceDirection = flowDirectionService.reloadFlowSourceDirection();
        if (flowDirectionService.hasCurrentFlowIsFinish()) {
            flowRecord.finish();
            flowRecord.submitRecord(currentOperator, snapshot, opinion, flowSourceDirection);
            this.flowRecordRepository.update(flowRecord);
            this.flowRecordRepository.finishFlowRecordByProcessId(flowRecord.getProcessId());
            EventPusher.push((IEvent)new FlowApprovalEvent(6, flowRecord, currentOperator, flowWork));
            return;
        }
        IFlowOperator createOperator = this.flowOperatorRepository.getFlowOperatorById(flowRecord.getCreateOperatorId());
        FlowRecordBuilderService flowRecordBuilderService = new FlowRecordBuilderService(this.flowOperatorRepository, this.flowRecordRepository, snapshot, opinion, createOperator, currentOperator, historyRecords, flowWork, flowRecord.getProcessId(), flowRecord.getId());
        List<FlowRecord> records = flowDirectionService.isPassBackRecord() ? flowRecordBuilderService.createNextRecord(flowNode) : (flowDirectionService.isDefaultBackRecord() ? flowRecordBuilderService.createDefaultBackRecord(flowRecord.getPreId()) : flowRecordBuilderService.createCustomBackRecord(flowNode, flowRecord.getPreId()));
        this.flowRecordRepository.save(records);
        int eventState = flowSourceDirection == FlowSourceDirection.PASS ? 2 : 3;
        EventPusher.push((IEvent)new FlowApprovalEvent(eventState, flowRecord, currentOperator, flowWork));
        for (FlowRecord record : records) {
            IFlowOperator pushOperator = this.flowOperatorRepository.getFlowOperatorById(record.getCurrentOperatorId());
            EventPusher.push((IEvent)new FlowApprovalEvent(7, record, pushOperator, flowWork));
        }
    }

    public void recall(long recordId, IFlowOperator currentOperator) {
        FlowRecordService flowRecordService = new FlowRecordService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordService.loadFlowRecord();
        flowRecordService.verifyFlowRecordCurrentOperator();
        flowRecordService.loadFlowWork();
        flowRecordService.loadFlowNode();
        flowRecordService.verifyFlowRecordNotFinish();
        flowRecordService.verifyFlowRecordNotTodo();
        FlowRecord flowRecord = flowRecordService.getFlowRecord();
        FlowWork flowWork = flowRecordService.getFlowWork();
        List<FlowRecord> childrenRecords = this.flowRecordRepository.findFlowRecordByPreId(recordId);
        if (childrenRecords.isEmpty()) {
            throw new IllegalArgumentException("flow record not submit");
        }
        boolean allUnDone = childrenRecords.stream().allMatch(item -> item.isUnRead() && item.isTodo());
        if (!allUnDone) {
            throw new IllegalArgumentException("flow record not recall");
        }
        flowRecord.recall();
        this.flowRecordRepository.update(flowRecord);
        this.flowRecordRepository.delete(childrenRecords);
        EventPusher.push((IEvent)new FlowApprovalEvent(5, flowRecord, currentOperator, flowWork));
    }

    @Generated
    public FlowService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowBindDataRepository flowBindDataRepository, FlowOperatorRepository flowOperatorRepository, FlowProcessRepository flowProcessRepository, FlowBackupRepository flowBackupRepository) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowBindDataRepository = flowBindDataRepository;
        this.flowOperatorRepository = flowOperatorRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.flowBackupRepository = flowBackupRepository;
    }
}

