/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.domain;

import com.codingapi.springboot.flow.content.FlowSession;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.em.NodeType;
import com.codingapi.springboot.flow.serializable.FlowRelationSerializable;
import com.codingapi.springboot.flow.trigger.OutTrigger;
import java.util.List;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class FlowRelation {
    private String id;
    private String name;
    private FlowNode source;
    private FlowNode target;
    private int order;
    private boolean back;
    private OutTrigger outTrigger;
    private long createTime;
    private long updateTime;

    public FlowRelationSerializable toSerializable() {
        return new FlowRelationSerializable(this.id, this.name, this.source.getId(), this.target.getId(), this.order, this.back, this.outTrigger.getScript(), this.createTime, this.updateTime);
    }

    public boolean sourceMatcher(String nodeCode) {
        return this.source.getCode().equals(nodeCode);
    }

    public void resort(int order) {
        this.order = order;
    }

    public FlowRelation(String id, String name, FlowNode source, FlowNode target, OutTrigger outTrigger, int order, boolean back) {
        this.id = id;
        this.name = name;
        this.source = source;
        this.target = target;
        this.outTrigger = outTrigger;
        this.order = order;
        this.back = back;
        this.createTime = System.currentTimeMillis();
        this.updateTime = System.currentTimeMillis();
    }

    public FlowNode trigger(FlowSession flowSession) {
        if (this.outTrigger.trigger(flowSession)) {
            return this.target;
        }
        return null;
    }

    public void verify() {
        if (!StringUtils.hasLength((String)this.id)) {
            throw new RuntimeException("id is null");
        }
        if (this.source == null || this.target == null) {
            throw new RuntimeException("source or target is null");
        }
        if (this.outTrigger == null) {
            throw new RuntimeException("outTrigger is null");
        }
        if (this.source.getCode().equals(this.target.getCode())) {
            throw new RuntimeException("source node code is equals target node code");
        }
        if (this.back && this.source.getType() != NodeType.APPROVAL) {
            throw new RuntimeException("source node type is not approval");
        }
    }

    public void verifyNodes(List<FlowNode> nodes) {
        if (nodes.stream().noneMatch(node -> node.getId().equals(this.source.getId()))) {
            throw new RuntimeException("source node is not exists");
        }
        if (nodes.stream().noneMatch(node -> node.getId().equals(this.target.getId()))) {
            throw new RuntimeException("target node is not exists");
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public FlowNode getSource() {
        return this.source;
    }

    @Generated
    public FlowNode getTarget() {
        return this.target;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public boolean isBack() {
        return this.back;
    }

    @Generated
    public OutTrigger getOutTrigger() {
        return this.outTrigger;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public FlowRelation(String id, String name, FlowNode source, FlowNode target, int order, boolean back, OutTrigger outTrigger, long createTime, long updateTime) {
        this.id = id;
        this.name = name;
        this.source = source;
        this.target = target;
        this.order = order;
        this.back = back;
        this.outTrigger = outTrigger;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }
}

