/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.domain;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.content.FlowSession;
import com.codingapi.springboot.flow.em.ApprovalType;
import com.codingapi.springboot.flow.em.FlowStatus;
import com.codingapi.springboot.flow.em.FlowType;
import com.codingapi.springboot.flow.em.NodeType;
import com.codingapi.springboot.flow.error.ErrTrigger;
import com.codingapi.springboot.flow.error.ErrorResult;
import com.codingapi.springboot.flow.generator.TitleGenerator;
import com.codingapi.springboot.flow.matcher.OperatorMatcher;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.serializable.FlowNodeSerializable;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.List;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class FlowNode {
    public static final String CODE_START = "start";
    public static final String CODE_OVER = "over";
    private String id;
    private String code;
    private String name;
    private TitleGenerator titleGenerator;
    private NodeType type;
    private String view;
    private ApprovalType approvalType;
    private OperatorMatcher operatorMatcher;
    private boolean editable;
    private long createTime;
    private long updateTime;
    private long timeout;
    private ErrTrigger errTrigger;

    public void verify() {
        if (this.titleGenerator == null) {
            throw new IllegalArgumentException("titleGenerator is null");
        }
        if (this.operatorMatcher == null) {
            throw new IllegalArgumentException("operatorMatcher is null");
        }
        if (this.timeout < 0L) {
            throw new IllegalArgumentException("timeout is less than 0");
        }
        if (!StringUtils.hasLength((String)this.id)) {
            throw new IllegalArgumentException("id is empty");
        }
        if (!StringUtils.hasLength((String)this.code)) {
            throw new IllegalArgumentException("code is empty");
        }
    }

    public FlowNodeSerializable toSerializable() {
        return new FlowNodeSerializable(this.id, this.code, this.name, this.titleGenerator.getScript(), this.type, this.view, this.approvalType, this.operatorMatcher.getScript(), this.editable, this.createTime, this.updateTime, this.timeout, this.errTrigger == null ? null : this.errTrigger.getScript());
    }

    public FlowNode(String id, String name, String code, String view, NodeType type, ApprovalType approvalType, TitleGenerator titleGenerator, OperatorMatcher operatorMatcher, long timeout, ErrTrigger errTrigger, boolean editable) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.titleGenerator = titleGenerator;
        this.type = type;
        this.view = view;
        this.approvalType = approvalType;
        this.operatorMatcher = operatorMatcher;
        this.createTime = System.currentTimeMillis();
        this.updateTime = System.currentTimeMillis();
        this.errTrigger = errTrigger;
        this.timeout = timeout;
        this.editable = editable;
    }

    public List<? extends IFlowOperator> loadFlowNodeOperator(FlowSession flowSession, FlowOperatorRepository flowOperatorRepository) {
        return flowOperatorRepository.findByIds(this.operatorMatcher.matcher(flowSession));
    }

    public FlowRecord createRecord(long workId, String workCode, String processId, long preId, String title, IFlowOperator createOperator, IFlowOperator currentOperator, BindDataSnapshot snapshot) {
        IFlowOperator flowOperator = currentOperator;
        while (flowOperator.entrustOperator() != null) {
            flowOperator = flowOperator.entrustOperator();
        }
        FlowRecord record = new FlowRecord();
        record.setProcessId(processId);
        record.setNodeCode(this.code);
        record.setCreateTime(System.currentTimeMillis());
        record.setWorkId(workId);
        record.setWorkCode(workCode);
        record.setFlowStatus(FlowStatus.RUNNING);
        record.setPostponedCount(0);
        record.setCreateOperator(createOperator);
        record.setBindClass(snapshot.getClazzName());
        record.setCurrentOperator(flowOperator);
        record.setPreId(preId);
        record.setTitle(title);
        record.setTimeoutTime(this.loadTimeoutTime());
        record.setFlowType(FlowType.TODO);
        record.setErrMessage(null);
        record.setSnapshotId(snapshot.getId());
        return record;
    }

    private long loadTimeoutTime() {
        if (this.timeout > 0L) {
            return System.currentTimeMillis() + this.timeout;
        }
        return 0L;
    }

    public boolean isAnyOperatorMatcher() {
        return this.operatorMatcher.isAny();
    }

    public ErrorResult errMatcher(FlowSession flowSession) {
        if (this.errTrigger != null) {
            return this.errTrigger.trigger(flowSession);
        }
        return null;
    }

    public boolean hasErrTrigger() {
        return this.errTrigger != null;
    }

    public String generateTitle(FlowSession flowSession) {
        return this.titleGenerator.generate(flowSession);
    }

    public boolean isSign() {
        return this.approvalType == ApprovalType.SIGN;
    }

    public boolean isUnSign() {
        return this.approvalType == ApprovalType.UN_SIGN;
    }

    public boolean isOverNode() {
        return CODE_OVER.equals(this.code);
    }

    public boolean isStartNode() {
        return CODE_START.equals(this.code);
    }

    public boolean isCirculate() {
        return this.approvalType == ApprovalType.CIRCULATE;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public TitleGenerator getTitleGenerator() {
        return this.titleGenerator;
    }

    @Generated
    public NodeType getType() {
        return this.type;
    }

    @Generated
    public String getView() {
        return this.view;
    }

    @Generated
    public ApprovalType getApprovalType() {
        return this.approvalType;
    }

    @Generated
    public OperatorMatcher getOperatorMatcher() {
        return this.operatorMatcher;
    }

    @Generated
    public boolean isEditable() {
        return this.editable;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public ErrTrigger getErrTrigger() {
        return this.errTrigger;
    }

    @Generated
    public FlowNode(String id, String code, String name, TitleGenerator titleGenerator, NodeType type, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher, boolean editable, long createTime, long updateTime, long timeout, ErrTrigger errTrigger) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.titleGenerator = titleGenerator;
        this.type = type;
        this.view = view;
        this.approvalType = approvalType;
        this.operatorMatcher = operatorMatcher;
        this.editable = editable;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.timeout = timeout;
        this.errTrigger = errTrigger;
    }

    @Generated
    public void setErrTrigger(ErrTrigger errTrigger) {
        this.errTrigger = errTrigger;
    }
}

