/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.content.FlowSession;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowRelation;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.error.ErrorResult;
import com.codingapi.springboot.flow.error.NodeResult;
import com.codingapi.springboot.flow.error.OperatorResult;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.ArrayList;
import java.util.List;

class FlowNodeService {
    private FlowNode nextNode;
    private IFlowOperator nextOperator;
    private final FlowOperatorRepository flowOperatorRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final String processId;
    private final long preId;
    private final FlowWork flowWork;
    private final Opinion opinion;
    private final IFlowOperator currentOperator;
    private final BindDataSnapshot snapshot;
    private final List<FlowRecord> historyRecords;
    private final IFlowOperator createOperator;

    public FlowNodeService(FlowOperatorRepository flowOperatorRepository, FlowRecordRepository flowRecordRepository, BindDataSnapshot snapshot, Opinion opinion, IFlowOperator createOperator, IFlowOperator currentOperator, List<FlowRecord> historyRecords, FlowWork flowWork, String processId, long preId) {
        this.flowOperatorRepository = flowOperatorRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.snapshot = snapshot;
        this.opinion = opinion;
        this.createOperator = createOperator;
        this.currentOperator = currentOperator;
        this.historyRecords = historyRecords;
        this.flowWork = flowWork;
        this.processId = processId;
        this.preId = preId;
    }

    public void setNextNode(FlowNode nextNode) {
        this.nextNode = nextNode;
        this.nextOperator = this.currentOperator;
    }

    public void loadNextPassNode(FlowNode currentNode) {
        this.nextNode = this.matcherNextNode(currentNode, false);
        this.nextOperator = this.currentOperator;
    }

    public void skipCirculate() {
        this.nextNode = this.matcherNextNode(this.nextNode, false);
        this.nextOperator = this.currentOperator;
    }

    public void loadDefaultBackNode(long parentRecordId) {
        FlowRecord preRecord = this.flowRecordRepository.getFlowRecordById(parentRecordId);
        while (!preRecord.isDone()) {
            preRecord = this.flowRecordRepository.getFlowRecordById(preRecord.getPreId());
        }
        IFlowOperator flowOperator = preRecord.getCurrentOperator();
        FlowNode nextNode = this.flowWork.getNodeByCode(preRecord.getNodeCode());
        if (nextNode == null) {
            throw new IllegalArgumentException("next node not found");
        }
        this.nextNode = nextNode;
        this.nextOperator = flowOperator;
    }

    public void loadCustomBackNode(FlowNode flowNode, long parentRecordId) {
        FlowNode nextNode = this.matcherNextNode(flowNode, true);
        if (nextNode == null) {
            throw new IllegalArgumentException("next node not found");
        }
        IFlowOperator flowOperator = this.currentOperator;
        if (nextNode.isAnyOperatorMatcher()) {
            FlowRecord preFlowRecord = this.flowRecordRepository.getFlowRecordById(parentRecordId);
            while (preFlowRecord.isTransfer() || !preFlowRecord.getNodeCode().equals(nextNode.getCode())) {
                preFlowRecord = this.flowRecordRepository.getFlowRecordById(preFlowRecord.getPreId());
            }
            flowOperator = preFlowRecord.getCurrentOperator();
        }
        this.nextNode = nextNode;
        this.nextOperator = flowOperator;
    }

    private FlowNode matcherNextNode(FlowNode flowNode, boolean back) {
        List<FlowRelation> relations = this.flowWork.getRelations().stream().filter(relation -> relation.sourceMatcher(flowNode.getCode())).filter(relation -> relation.isBack() == back).sorted((o1, o2) -> o2.getOrder() - o1.getOrder()).toList();
        if (relations.isEmpty()) {
            throw new IllegalArgumentException("relation not found");
        }
        FlowSession flowSession = new FlowSession(this.flowWork, flowNode, this.createOperator, this.currentOperator, this.snapshot.toBindData(), this.opinion, this.historyRecords);
        ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
        for (FlowRelation flowRelation : relations) {
            FlowNode node = flowRelation.trigger(flowSession);
            if (node == null) continue;
            flowNodes.add(node);
        }
        if (flowNodes.isEmpty()) {
            throw new IllegalArgumentException("next node not found");
        }
        return (FlowNode)flowNodes.get(0);
    }

    public List<FlowRecord> createRecord() {
        List<FlowRecord> records = this.createNextRecord();
        while (this.nextNodeIsCirculate()) {
            for (FlowRecord record : records) {
                record.circulate();
            }
            this.flowRecordRepository.save(records);
            for (FlowRecord record : records) {
                IFlowOperator pushOperator = record.getCurrentOperator();
                EventPusher.push((IEvent)new FlowApprovalEvent(9, record, pushOperator, this.flowWork, this.snapshot.toBindData()), (boolean)true);
            }
            this.skipCirculate();
            records = this.createNextRecord();
        }
        return records;
    }

    private List<FlowRecord> createNextRecord() {
        List<FlowRecord> recordList;
        FlowSession flowSession = new FlowSession(this.flowWork, this.nextNode, this.createOperator, this.nextOperator, this.snapshot.toBindData(), this.opinion, this.historyRecords);
        long workId = this.flowWork.getId();
        List<? extends IFlowOperator> operators = this.nextNode.loadFlowNodeOperator(flowSession, this.flowOperatorRepository);
        if (operators.isEmpty()) {
            recordList = this.errMatcher(this.nextNode, this.nextOperator);
            if (recordList.isEmpty()) {
                throw new IllegalArgumentException("operator not match.");
            }
        } else {
            String recordTitle = this.nextNode.generateTitle(flowSession);
            recordList = new ArrayList<FlowRecord>();
            for (IFlowOperator iFlowOperator : operators) {
                FlowRecord record = this.nextNode.createRecord(workId, this.flowWork.getCode(), this.processId, this.preId, recordTitle, this.createOperator, iFlowOperator, this.snapshot);
                recordList.add(record);
            }
        }
        return recordList;
    }

    private List<FlowRecord> errMatcher(FlowNode currentNode, IFlowOperator currentOperator) {
        if (currentNode.hasErrTrigger()) {
            FlowSession flowSession = new FlowSession(this.flowWork, currentNode, this.createOperator, currentOperator, this.snapshot.toBindData(), this.opinion, this.historyRecords);
            ErrorResult errorResult = currentNode.errMatcher(flowSession);
            if (errorResult == null) {
                throw new IllegalArgumentException("errMatcher match error.");
            }
            if (errorResult.isOperator()) {
                ArrayList<FlowRecord> recordList = new ArrayList<FlowRecord>();
                List<Long> operatorIds = ((OperatorResult)errorResult).getOperatorIds();
                List<? extends IFlowOperator> operators = this.flowOperatorRepository.findByIds(operatorIds);
                for (IFlowOperator iFlowOperator : operators) {
                    FlowSession content = new FlowSession(this.flowWork, currentNode, this.createOperator, iFlowOperator, this.snapshot.toBindData(), this.opinion, this.historyRecords);
                    String string = currentNode.generateTitle(content);
                    FlowRecord record = currentNode.createRecord(this.flowWork.getId(), this.flowWork.getCode(), this.processId, this.preId, string, this.createOperator, iFlowOperator, this.snapshot);
                    recordList.add(record);
                }
                return recordList;
            }
            if (errorResult.isNode()) {
                String nodeCode = ((NodeResult)errorResult).getNode();
                FlowNode node = this.flowWork.getNodeByCode(nodeCode);
                if (node == null) {
                    throw new IllegalArgumentException("node not found.");
                }
                ArrayList<FlowRecord> recordList = new ArrayList<FlowRecord>();
                FlowSession content = new FlowSession(this.flowWork, node, this.createOperator, currentOperator, this.snapshot.toBindData(), this.opinion, this.historyRecords);
                List<? extends IFlowOperator> list = node.loadFlowNodeOperator(content, this.flowOperatorRepository);
                if (!list.isEmpty()) {
                    for (IFlowOperator iFlowOperator : list) {
                        String recordTitle = node.generateTitle(content);
                        FlowRecord record = node.createRecord(this.flowWork.getId(), this.flowWork.getCode(), this.processId, this.preId, recordTitle, this.createOperator, iFlowOperator, this.snapshot);
                        recordList.add(record);
                    }
                }
                return recordList;
            }
            throw new IllegalArgumentException("errMatcher not match.");
        }
        throw new IllegalArgumentException("operator not match.");
    }

    public boolean nextNodeIsCirculate() {
        return this.nextNode.isCirculate();
    }

    public boolean nextNodeIsOver() {
        return this.nextNode.isOverNode();
    }
}

