/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.content.FlowSession;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.pojo.FlowDetail;
import com.codingapi.springboot.flow.pojo.FlowNodeResult;
import com.codingapi.springboot.flow.pojo.FlowResult;
import com.codingapi.springboot.flow.record.FlowBackup;
import com.codingapi.springboot.flow.record.FlowProcess;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBackupRepository;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowDirectionService;
import com.codingapi.springboot.flow.service.FlowNodeService;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowService {
    private final FlowWorkRepository flowWorkRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowBindDataRepository flowBindDataRepository;
    private final FlowOperatorRepository flowOperatorRepository;
    private final FlowProcessRepository flowProcessRepository;
    private final FlowBackupRepository flowBackupRepository;

    public FlowDetail detail(long recordId) {
        return this.detail(recordId, null);
    }

    public void postponed(long recordId, IFlowOperator currentOperator, long time) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordSubmitState();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.verifyFlowRecordNotFinish();
        flowRecordVerifyService.verifyFlowRecordNotDone();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        flowRecord.postponedTime(flowWork.getPostponedMax(), time);
        this.flowRecordRepository.update(flowRecord);
    }

    public void urge(long recordId, IFlowOperator currentOperator) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.verifyFlowRecordIsDone();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        List<FlowRecord> todoRecords = this.flowRecordRepository.findTodoFlowRecordByProcessId(flowRecord.getProcessId());
        for (FlowRecord record : todoRecords) {
            IFlowOperator pushOperator = record.getCurrentOperator();
            EventPusher.push((IEvent)new FlowApprovalEvent(8, record, pushOperator, flowWork, null), (boolean)true);
        }
    }

    public FlowDetail detail(long recordId, IFlowOperator currentOperator) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.setFlowRecordRead();
        flowRecordVerifyService.loadFlowWork();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        BindDataSnapshot snapshot = this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        List<FlowRecord> flowRecords = this.flowRecordRepository.findFlowRecordByProcessId(flowRecord.getProcessId()).stream().sorted((o1, o2) -> (int)(o2.getId() - o1.getId())).toList();
        ArrayList<IFlowOperator> operators = new ArrayList<IFlowOperator>();
        for (FlowRecord record : flowRecords) {
            operators.add(record.getCreateOperator());
            operators.add(record.getCurrentOperator());
            if (record.getInterferedOperator() == null) continue;
            operators.add(record.getInterferedOperator());
        }
        return new FlowDetail(flowRecord, snapshot, flowWork, flowRecords, operators);
    }

    public FlowResult interfere(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        if (!currentOperator.isFlowManager()) {
            throw new IllegalArgumentException("current operator is not flow manager");
        }
        return this.submitFlow(recordId, currentOperator, bindData, opinion);
    }

    public void transfer(long recordId, IFlowOperator currentOperator, IFlowOperator targetOperator, IBindData bindData, String advice) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordSubmitState();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.verifyTargetOperatorIsNotCurrentOperator(targetOperator);
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyFlowRecordIsTodo();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        FlowNode flowNode = flowRecordVerifyService.getFlowNode();
        BindDataSnapshot snapshot = new BindDataSnapshot(bindData);
        this.flowBindDataRepository.save(snapshot);
        Opinion opinion = Opinion.transfer(advice);
        flowRecord.transfer(currentOperator, snapshot, opinion);
        this.flowRecordRepository.update(flowRecord);
        IFlowOperator createOperator = flowRecord.getCreateOperator();
        List<Object> historyRecords = flowRecord.isStartRecord() ? new ArrayList() : this.flowRecordRepository.findFlowRecordByPreId(flowRecord.getPreId());
        FlowSession content = new FlowSession(flowWork, flowNode, createOperator, targetOperator, snapshot.toBindData(), opinion, historyRecords);
        String generateTitle = flowNode.generateTitle(content);
        FlowRecord transferRecord = flowRecord.copy();
        transferRecord.transferToTodo(generateTitle, targetOperator);
        this.flowRecordRepository.save(List.of(transferRecord));
        EventPusher.push((IEvent)new FlowApprovalEvent(4, flowRecord, currentOperator, flowWork, snapshot.toBindData()), (boolean)true);
        EventPusher.push((IEvent)new FlowApprovalEvent(7, transferRecord, targetOperator, flowWork, snapshot.toBindData()), (boolean)true);
    }

    public void save(long recordId, IFlowOperator currentOperator, IBindData bindData, String advice) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordSubmitState();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyFlowNodeEditableState(false);
        Opinion opinion = Opinion.save(advice);
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        BindDataSnapshot snapshot = new BindDataSnapshot(flowRecord.getSnapshotId(), bindData);
        this.flowBindDataRepository.update(snapshot);
        flowRecord.setOpinion(opinion);
        flowRecordVerifyService.flowRecordRepository.update(flowRecord);
    }

    public FlowResult startFlow(String workCode, IFlowOperator operator, IBindData bindData, String advice) {
        FlowWork flowWork = this.flowWorkRepository.getFlowWorkByCode(workCode);
        if (flowWork == null) {
            throw new IllegalArgumentException("flow work not found");
        }
        flowWork.verify();
        flowWork.enableValidate();
        FlowBackup flowBackup = this.flowBackupRepository.getFlowBackupByWorkIdAndVersion(flowWork.getId(), flowWork.getUpdateTime());
        if (flowBackup == null) {
            flowBackup = this.flowBackupRepository.backup(flowWork);
        }
        FlowProcess flowProcess = new FlowProcess(flowBackup.getId(), operator);
        this.flowProcessRepository.save(flowProcess);
        BindDataSnapshot snapshot = new BindDataSnapshot(bindData);
        this.flowBindDataRepository.save(snapshot);
        String processId = flowProcess.getProcessId();
        Opinion opinion = Opinion.pass(advice);
        FlowNode start = flowWork.getStartNode();
        if (start == null) {
            throw new IllegalArgumentException("start node not found");
        }
        long preId = 0L;
        ArrayList<FlowRecord> historyRecords = new ArrayList<FlowRecord>();
        FlowNodeService flowNodeService = new FlowNodeService(this.flowOperatorRepository, this.flowRecordRepository, snapshot, opinion, operator, operator, historyRecords, flowWork, processId, preId);
        flowNodeService.setNextNode(start);
        List<FlowRecord> records = flowNodeService.createRecord();
        if (records.isEmpty()) {
            throw new IllegalArgumentException("flow record not found");
        }
        for (FlowRecord record : records) {
            record.updateOpinion(opinion);
        }
        if (flowNodeService.nextNodeIsOver()) {
            for (FlowRecord record : records) {
                record.submitRecord(operator, snapshot, opinion, FlowSourceDirection.PASS);
                record.finish();
            }
            this.flowRecordRepository.save(records);
            for (FlowRecord record : records) {
                EventPusher.push((IEvent)new FlowApprovalEvent(1, record, operator, flowWork, snapshot.toBindData()), (boolean)true);
                EventPusher.push((IEvent)new FlowApprovalEvent(6, record, operator, flowWork, snapshot.toBindData()), (boolean)true);
            }
            return new FlowResult(flowWork, records);
        }
        this.flowRecordRepository.save(records);
        for (FlowRecord record : records) {
            EventPusher.push((IEvent)new FlowApprovalEvent(1, record, operator, flowWork, snapshot.toBindData()), (boolean)true);
            EventPusher.push((IEvent)new FlowApprovalEvent(7, record, operator, flowWork, snapshot.toBindData()), (boolean)true);
        }
        return new FlowResult(flowWork, records);
    }

    public FlowNodeResult trySubmitFlow(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        boolean next;
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordSubmitState();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyChildrenRecordsIsEmpty();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord().copy();
        FlowNode flowNode = flowRecordVerifyService.getFlowNode();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        BindDataSnapshot snapshot = null;
        snapshot = flowNode.isEditable() ? new BindDataSnapshot(bindData) : this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        FlowDirectionService flowDirectionService = new FlowDirectionService(flowRecordVerifyService.getFlowNode(), flowRecordVerifyService.getFlowWork(), opinion);
        flowDirectionService.loadFlowSourceDirection();
        flowDirectionService.verifyFlowSourceDirection();
        FlowSourceDirection flowSourceDirection = flowDirectionService.getFlowSourceDirection();
        flowRecord.submitRecord(currentOperator, snapshot, opinion, flowSourceDirection);
        List<FlowRecord> historyRecords = flowRecord.isStartRecord() ? new ArrayList<FlowRecord>() : this.flowRecordRepository.findFlowRecordByPreId(flowRecord.getPreId()).stream().map(FlowRecord::copy).toList();
        flowDirectionService.bindHistoryRecords(historyRecords);
        if (flowNode.isSign() && (next = flowDirectionService.hasCurrentFlowNodeIsDone())) {
            List<FlowRecord> todoRecords = historyRecords.stream().filter(FlowRecord::isTodo).toList();
            return new FlowNodeResult(flowWork, flowNode, todoRecords.stream().map(FlowRecord::getCurrentOperator).toList());
        }
        if (flowNode.isUnSign()) {
            for (FlowRecord record : historyRecords) {
                if (!record.isTodo() || record.getId() == flowRecord.getId()) continue;
                record.autoPass(currentOperator, snapshot);
            }
        }
        flowDirectionService.reloadFlowSourceDirection();
        IFlowOperator createOperator = flowRecord.getCreateOperator();
        FlowNodeService flowNodeService = new FlowNodeService(this.flowOperatorRepository, this.flowRecordRepository, snapshot, opinion, createOperator, currentOperator, historyRecords, flowWork, flowRecord.getProcessId(), flowRecord.getId());
        if (flowDirectionService.isPassRecord()) {
            flowNodeService.loadNextPassNode(flowNode);
        } else if (flowDirectionService.isDefaultBackRecord()) {
            flowNodeService.loadDefaultBackNode(flowRecord.getPreId());
        } else {
            flowNodeService.loadCustomBackNode(flowNode, flowRecord.getPreId());
        }
        List<? extends IFlowOperator> operators = flowNodeService.loadNextNodeOperators();
        return new FlowNodeResult(flowWork, flowNode, operators);
    }

    public FlowResult submitFlow(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        boolean next;
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordSubmitState();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyChildrenRecordsIsEmpty();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowNode flowNode = flowRecordVerifyService.getFlowNode();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        BindDataSnapshot snapshot = null;
        if (flowNode.isEditable()) {
            snapshot = new BindDataSnapshot(bindData);
            this.flowBindDataRepository.save(snapshot);
        } else {
            snapshot = this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        }
        FlowDirectionService flowDirectionService = new FlowDirectionService(flowRecordVerifyService.getFlowNode(), flowRecordVerifyService.getFlowWork(), opinion);
        flowDirectionService.loadFlowSourceDirection();
        flowDirectionService.verifyFlowSourceDirection();
        FlowSourceDirection flowSourceDirection = flowDirectionService.getFlowSourceDirection();
        flowRecord.submitRecord(currentOperator, snapshot, opinion, flowSourceDirection);
        this.flowRecordRepository.update(flowRecord);
        List<Object> historyRecords = flowRecord.isStartRecord() ? new ArrayList() : this.flowRecordRepository.findFlowRecordByPreId(flowRecord.getPreId());
        flowDirectionService.bindHistoryRecords(historyRecords);
        if (flowNode.isSign() && (next = flowDirectionService.hasCurrentFlowNodeIsDone())) {
            List<FlowRecord> todoRecords = historyRecords.stream().filter(FlowRecord::isTodo).toList();
            return new FlowResult(flowWork, todoRecords);
        }
        if (flowNode.isUnSign()) {
            for (FlowRecord record : historyRecords) {
                if (!record.isTodo() || record.getId() == flowRecord.getId()) continue;
                record.autoPass(currentOperator, snapshot);
                this.flowRecordRepository.update(flowRecord);
            }
        }
        flowSourceDirection = flowDirectionService.reloadFlowSourceDirection();
        IFlowOperator createOperator = flowRecord.getCreateOperator();
        FlowNodeService flowNodeService = new FlowNodeService(this.flowOperatorRepository, this.flowRecordRepository, snapshot, opinion, createOperator, currentOperator, historyRecords, flowWork, flowRecord.getProcessId(), flowRecord.getId());
        if (flowDirectionService.isPassRecord()) {
            flowNodeService.loadNextPassNode(flowNode);
        } else if (flowDirectionService.isDefaultBackRecord()) {
            flowNodeService.loadDefaultBackNode(flowRecord.getPreId());
        } else {
            flowNodeService.loadCustomBackNode(flowNode, flowRecord.getPreId());
        }
        List<FlowRecord> records = flowNodeService.createRecord();
        if (flowNodeService.nextNodeIsOver()) {
            flowRecord.submitRecord(currentOperator, snapshot, opinion, flowSourceDirection);
            flowRecord.finish();
            this.flowRecordRepository.update(flowRecord);
            this.flowRecordRepository.finishFlowRecordByProcessId(flowRecord.getProcessId());
            EventPusher.push((IEvent)new FlowApprovalEvent(6, flowRecord, currentOperator, flowWork, snapshot.toBindData()), (boolean)true);
            return new FlowResult(flowWork, flowRecord);
        }
        this.flowRecordRepository.save(records);
        int eventState = flowSourceDirection == FlowSourceDirection.PASS ? 2 : 3;
        EventPusher.push((IEvent)new FlowApprovalEvent(eventState, flowRecord, currentOperator, flowWork, snapshot.toBindData()), (boolean)true);
        for (FlowRecord record : records) {
            IFlowOperator pushOperator = record.getCurrentOperator();
            EventPusher.push((IEvent)new FlowApprovalEvent(7, record, pushOperator, flowWork, snapshot.toBindData()), (boolean)true);
        }
        return new FlowResult(flowWork, records);
    }

    public void recall(long recordId, IFlowOperator currentOperator) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyFlowRecordNotFinish();
        flowRecordVerifyService.verifyFlowRecordNotTodo();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        List<FlowRecord> childrenRecords = this.flowRecordRepository.findFlowRecordByPreId(recordId);
        if (flowRecord.isStartRecord() && flowRecord.isTodo()) {
            if (!childrenRecords.isEmpty()) {
                throw new IllegalArgumentException("flow record not recall");
            }
            this.flowRecordRepository.delete(List.of(flowRecord));
        } else {
            if (childrenRecords.isEmpty()) {
                throw new IllegalArgumentException("flow record not submit");
            }
            boolean allUnDone = childrenRecords.stream().allMatch(item -> item.isUnRead() && item.isTodo());
            if (!allUnDone) {
                throw new IllegalArgumentException("flow record not recall");
            }
            flowRecord.recall();
            this.flowRecordRepository.update(flowRecord);
            this.flowRecordRepository.delete(childrenRecords);
        }
        EventPusher.push((IEvent)new FlowApprovalEvent(5, flowRecord, currentOperator, flowWork, null), (boolean)true);
    }

    @Generated
    public FlowService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowBindDataRepository flowBindDataRepository, FlowOperatorRepository flowOperatorRepository, FlowProcessRepository flowProcessRepository, FlowBackupRepository flowBackupRepository) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowBindDataRepository = flowBindDataRepository;
        this.flowOperatorRepository = flowOperatorRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.flowBackupRepository = flowBackupRepository;
    }
}

