/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.bind;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.springboot.flow.bind.IBindData;
import lombok.Generated;

public class BindDataSnapshot {
    private long id;
    private String snapshot;
    private long createTime;
    private String clazzName;

    public BindDataSnapshot(long id, IBindData bindData) {
        if (bindData == null) {
            throw new IllegalArgumentException("bind data is null");
        }
        this.snapshot = bindData.toJsonSnapshot();
        this.clazzName = bindData.getClass().getName();
        this.createTime = System.currentTimeMillis();
        this.id = id;
    }

    public BindDataSnapshot(IBindData bindData) {
        this(0L, bindData);
    }

    public IBindData toBindData() {
        try {
            return (IBindData)JSONObject.parseObject((String)this.snapshot, Class.forName(this.clazzName));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bind data error");
        }
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setClazzName(String clazzName) {
        this.clazzName = clazzName;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getSnapshot() {
        return this.snapshot;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public String getClazzName() {
        return this.clazzName;
    }

    @Generated
    public BindDataSnapshot(long id, String snapshot, long createTime, String clazzName) {
        this.id = id;
        this.snapshot = snapshot;
        this.createTime = createTime;
        this.clazzName = clazzName;
    }
}

