/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service;

import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.pojo.FlowDetail;
import com.codingapi.springboot.flow.pojo.FlowResult;
import com.codingapi.springboot.flow.pojo.FlowSubmitResult;
import com.codingapi.springboot.flow.repository.FlowBackupRepository;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.impl.FlowCustomEventService;
import com.codingapi.springboot.flow.service.impl.FlowDetailService;
import com.codingapi.springboot.flow.service.impl.FlowPostponedService;
import com.codingapi.springboot.flow.service.impl.FlowRecallService;
import com.codingapi.springboot.flow.service.impl.FlowSaveService;
import com.codingapi.springboot.flow.service.impl.FlowStartService;
import com.codingapi.springboot.flow.service.impl.FlowSubmitService;
import com.codingapi.springboot.flow.service.impl.FlowTransferService;
import com.codingapi.springboot.flow.service.impl.FlowTrySubmitService;
import com.codingapi.springboot.flow.service.impl.FlowUrgeService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
public class FlowService {
    private final FlowDetailService flowDetailService;
    private final FlowStartService flowStartService;
    private final FlowSubmitService flowSubmitService;
    private final FlowCustomEventService flowCustomEventService;
    private final FlowRecallService flowRecallService;
    private final FlowTrySubmitService flowTrySubmitService;
    private final FlowSaveService flowSaveService;
    private final FlowTransferService flowTransferService;
    private final FlowPostponedService flowPostponedService;
    private final FlowUrgeService flowUrgeService;

    public FlowService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowBindDataRepository flowBindDataRepository, FlowOperatorRepository flowOperatorRepository, FlowProcessRepository flowProcessRepository, FlowBackupRepository flowBackupRepository) {
        this.flowDetailService = new FlowDetailService(flowWorkRepository, flowRecordRepository, flowBindDataRepository, flowOperatorRepository, flowProcessRepository);
        this.flowStartService = new FlowStartService(flowWorkRepository, flowRecordRepository, flowBindDataRepository, flowOperatorRepository, flowProcessRepository, flowBackupRepository);
        this.flowSubmitService = new FlowSubmitService(flowRecordRepository, flowBindDataRepository, flowOperatorRepository, flowProcessRepository);
        this.flowCustomEventService = new FlowCustomEventService(flowRecordRepository, flowProcessRepository);
        this.flowRecallService = new FlowRecallService(flowRecordRepository, flowProcessRepository);
        this.flowTrySubmitService = new FlowTrySubmitService(flowRecordRepository, flowBindDataRepository, flowOperatorRepository, flowProcessRepository, flowWorkRepository, flowBackupRepository);
        this.flowSaveService = new FlowSaveService(flowRecordRepository, flowBindDataRepository, flowProcessRepository);
        this.flowTransferService = new FlowTransferService(flowRecordRepository, flowBindDataRepository, flowProcessRepository);
        this.flowPostponedService = new FlowPostponedService(flowRecordRepository, flowProcessRepository);
        this.flowUrgeService = new FlowUrgeService(flowRecordRepository, flowProcessRepository);
    }

    public FlowDetail detail(long recordId, String workCode, IFlowOperator currentOperator) {
        if (StringUtils.hasText((String)workCode)) {
            return this.flowDetailService.detail(workCode, currentOperator);
        }
        return this.flowDetailService.detail(recordId, currentOperator);
    }

    public FlowDetail detail(long recordId, IFlowOperator currentOperator) {
        return this.detail(recordId, null, currentOperator);
    }

    public FlowDetail detail(String workCode, IFlowOperator currentOperator) {
        return this.detail(0L, workCode, currentOperator);
    }

    public FlowDetail detail(long recordId) {
        return this.detail(recordId, null, null);
    }

    public void postponed(long recordId, IFlowOperator currentOperator, long time) {
        this.flowPostponedService.postponed(recordId, currentOperator, time);
    }

    public void urge(long recordId, IFlowOperator currentOperator) {
        this.flowUrgeService.urge(recordId, currentOperator);
    }

    public FlowResult interfere(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        if (!currentOperator.isFlowManager()) {
            throw new IllegalArgumentException("current operator is not flow manager");
        }
        return this.submitFlow(recordId, currentOperator, bindData, opinion);
    }

    public void transfer(long recordId, IFlowOperator currentOperator, IFlowOperator targetOperator, IBindData bindData, String advice) {
        this.flowTransferService.transfer(recordId, currentOperator, targetOperator, bindData, advice);
    }

    public void save(long recordId, IFlowOperator currentOperator, IBindData bindData, String advice) {
        this.flowSaveService.save(recordId, currentOperator, bindData, advice);
    }

    public FlowResult startFlow(String workCode, IFlowOperator operator, IBindData bindData, String advice) {
        return this.flowStartService.startFlow(workCode, operator, bindData, advice);
    }

    public FlowSubmitResult trySubmitFlow(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        return this.flowTrySubmitService.trySubmitFlow(recordId, currentOperator, bindData, opinion);
    }

    public FlowSubmitResult trySubmitFlow(String workCode, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        return this.flowTrySubmitService.trySubmitFlow(workCode, currentOperator, bindData, opinion);
    }

    public FlowResult submitFlow(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        return this.flowSubmitService.submitFlow(recordId, currentOperator, bindData, opinion);
    }

    public String customFlowEvent(long recordId, IFlowOperator currentOperator, String buttonId, IBindData bindData, Opinion opinion) {
        return this.flowCustomEventService.customFlowEvent(recordId, currentOperator, buttonId, bindData, opinion);
    }

    public void recall(long recordId, IFlowOperator currentOperator) {
        this.flowRecallService.recall(recordId, currentOperator);
    }
}

