/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.pojo.FlowSubmitResult;
import com.codingapi.springboot.flow.record.FlowBackup;
import com.codingapi.springboot.flow.record.FlowProcess;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBackupRepository;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowDirectionService;
import com.codingapi.springboot.flow.service.FlowNodeService;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowTrySubmitService {
    private final FlowRecordRepository flowRecordRepository;
    private final FlowBindDataRepository flowBindDataRepository;
    private final FlowOperatorRepository flowOperatorRepository;
    private final FlowProcessRepository flowProcessRepository;
    private final FlowWorkRepository flowWorkRepository;
    private final FlowBackupRepository flowBackupRepository;

    public FlowSubmitResult trySubmitFlow(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordSubmitState();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyChildrenRecordsIsEmpty();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord().copy();
        FlowNode flowNode = flowRecordVerifyService.getFlowNode();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        return this.trySubmitFlow(flowWork, flowNode, flowRecord, currentOperator, bindData, opinion);
    }

    private FlowSubmitResult trySubmitFlow(FlowWork flowWork, FlowNode flowNode, FlowRecord flowRecord, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        boolean next;
        BindDataSnapshot snapshot = null;
        snapshot = flowNode.isEditable() ? new BindDataSnapshot(bindData) : this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        FlowDirectionService flowDirectionService = new FlowDirectionService(flowNode, flowWork, opinion);
        flowDirectionService.loadFlowSourceDirection();
        flowDirectionService.verifyFlowSourceDirection();
        FlowSourceDirection flowSourceDirection = flowDirectionService.getFlowSourceDirection();
        flowRecord.submitRecord(currentOperator, snapshot, opinion, flowSourceDirection);
        List<FlowRecord> historyRecords = flowRecord.isStartRecord() ? new ArrayList<FlowRecord>() : this.flowRecordRepository.findFlowRecordByPreId(flowRecord.getPreId()).stream().map(FlowRecord::copy).toList();
        flowDirectionService.bindHistoryRecords(historyRecords);
        if (flowNode.isSign() && (next = flowDirectionService.hasCurrentFlowNodeIsDone())) {
            List<FlowRecord> todoRecords = historyRecords.stream().filter(FlowRecord::isTodo).toList();
            return new FlowSubmitResult(flowWork, flowNode, todoRecords.stream().map(FlowRecord::getCurrentOperator).toList());
        }
        if (flowNode.isUnSign()) {
            for (FlowRecord record : historyRecords) {
                if (!record.isTodo() || record.getId() == flowRecord.getId()) continue;
                record.autoPass(currentOperator, snapshot);
            }
        }
        flowDirectionService.reloadFlowSourceDirection();
        IFlowOperator createOperator = flowRecord.getCreateOperator();
        FlowNodeService flowNodeService = new FlowNodeService(this.flowOperatorRepository, this.flowRecordRepository, snapshot, opinion, createOperator, currentOperator, historyRecords, flowWork, flowRecord.getProcessId(), flowRecord.getId());
        if (flowDirectionService.isPassRecord()) {
            flowNodeService.loadNextPassNode(flowNode);
        } else if (flowDirectionService.isDefaultBackRecord()) {
            flowNodeService.loadDefaultBackNode(flowRecord.getPreId());
        } else {
            flowNodeService.loadCustomBackNode(flowNode, flowRecord.getPreId());
        }
        FlowNode nextNode = flowNodeService.getNextNode();
        List<? extends IFlowOperator> operators = flowNodeService.loadNextNodeOperators();
        return new FlowSubmitResult(flowWork, nextNode, operators);
    }

    public FlowSubmitResult trySubmitFlow(String workCode, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        FlowWork flowWork = this.flowWorkRepository.getFlowWorkByCode(workCode);
        if (flowWork == null) {
            throw new IllegalArgumentException("flow work not found");
        }
        flowWork.verify();
        flowWork.enableValidate();
        FlowBackup flowBackup = this.flowBackupRepository.getFlowBackupByWorkIdAndVersion(flowWork.getId(), flowWork.getUpdateTime());
        if (flowBackup == null) {
            flowBackup = this.flowBackupRepository.backup(flowWork);
        }
        FlowProcess flowProcess = new FlowProcess(flowBackup.getId(), currentOperator);
        BindDataSnapshot snapshot = new BindDataSnapshot(bindData);
        String processId = flowProcess.getProcessId();
        FlowNode start = flowWork.getStartNode();
        if (start == null) {
            throw new IllegalArgumentException("start node not found");
        }
        long preId = 0L;
        ArrayList<FlowRecord> historyRecords = new ArrayList<FlowRecord>();
        FlowNodeService flowNodeService = new FlowNodeService(this.flowOperatorRepository, this.flowRecordRepository, snapshot, opinion, currentOperator, currentOperator, historyRecords, flowWork, processId, preId);
        flowNodeService.setNextNode(start);
        FlowRecord startRecord = null;
        List<FlowRecord> records = flowNodeService.createRecord();
        if (records.isEmpty()) {
            throw new IllegalArgumentException("flow record not found");
        }
        for (FlowRecord record : records) {
            record.updateOpinion(opinion);
            startRecord = record;
        }
        if (flowNodeService.nextNodeIsOver()) {
            for (FlowRecord record : records) {
                record.submitRecord(currentOperator, snapshot, opinion, FlowSourceDirection.PASS);
                record.finish();
                startRecord = record;
            }
        }
        return this.trySubmitFlow(flowWork, start, startRecord, currentOperator, bindData, opinion);
    }

    @Generated
    public FlowTrySubmitService(FlowRecordRepository flowRecordRepository, FlowBindDataRepository flowBindDataRepository, FlowOperatorRepository flowOperatorRepository, FlowProcessRepository flowProcessRepository, FlowWorkRepository flowWorkRepository, FlowBackupRepository flowBackupRepository) {
        this.flowRecordRepository = flowRecordRepository;
        this.flowBindDataRepository = flowBindDataRepository;
        this.flowOperatorRepository = flowOperatorRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.flowWorkRepository = flowWorkRepository;
        this.flowBackupRepository = flowBackupRepository;
    }
}

