/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.pojo.FlowResult;
import com.codingapi.springboot.flow.record.FlowBackup;
import com.codingapi.springboot.flow.record.FlowProcess;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBackupRepository;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowNodeService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowStartService {
    private final FlowWorkRepository flowWorkRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowBindDataRepository flowBindDataRepository;
    private final FlowOperatorRepository flowOperatorRepository;
    private final FlowProcessRepository flowProcessRepository;
    private final FlowBackupRepository flowBackupRepository;

    public FlowResult startFlow(String workCode, IFlowOperator operator, IBindData bindData, String advice) {
        FlowWork flowWork = this.flowWorkRepository.getFlowWorkByCode(workCode);
        if (flowWork == null) {
            throw new IllegalArgumentException("flow work not found");
        }
        flowWork.verify();
        flowWork.enableValidate();
        FlowBackup flowBackup = this.flowBackupRepository.getFlowBackupByWorkIdAndVersion(flowWork.getId(), flowWork.getUpdateTime());
        if (flowBackup == null) {
            flowBackup = this.flowBackupRepository.backup(flowWork);
        }
        FlowProcess flowProcess = new FlowProcess(flowBackup.getId(), operator);
        this.flowProcessRepository.save(flowProcess);
        BindDataSnapshot snapshot = new BindDataSnapshot(bindData);
        this.flowBindDataRepository.save(snapshot);
        String processId = flowProcess.getProcessId();
        Opinion opinion = Opinion.pass(advice);
        FlowNode start = flowWork.getStartNode();
        if (start == null) {
            throw new IllegalArgumentException("start node not found");
        }
        long preId = 0L;
        ArrayList<FlowRecord> historyRecords = new ArrayList<FlowRecord>();
        FlowNodeService flowNodeService = new FlowNodeService(this.flowOperatorRepository, this.flowRecordRepository, snapshot, opinion, operator, operator, historyRecords, flowWork, processId, preId);
        flowNodeService.setNextNode(start);
        List<FlowRecord> records = flowNodeService.createRecord();
        if (records.isEmpty()) {
            throw new IllegalArgumentException("flow record not found");
        }
        for (FlowRecord record : records) {
            record.updateOpinion(opinion);
        }
        if (flowNodeService.nextNodeIsOver()) {
            for (FlowRecord record : records) {
                record.submitRecord(operator, snapshot, opinion, FlowSourceDirection.PASS);
                record.finish();
            }
            this.flowRecordRepository.save(records);
            for (FlowRecord record : records) {
                EventPusher.push((IEvent)new FlowApprovalEvent(1, record, operator, flowWork, snapshot.toBindData()), (boolean)true);
                EventPusher.push((IEvent)new FlowApprovalEvent(6, record, operator, flowWork, snapshot.toBindData()), (boolean)true);
            }
            return new FlowResult(flowWork, records);
        }
        this.flowRecordRepository.save(records);
        for (FlowRecord record : records) {
            EventPusher.push((IEvent)new FlowApprovalEvent(1, record, operator, flowWork, snapshot.toBindData()), (boolean)true);
            EventPusher.push((IEvent)new FlowApprovalEvent(7, record, operator, flowWork, snapshot.toBindData()), (boolean)true);
        }
        return new FlowResult(flowWork, records);
    }

    @Generated
    public FlowStartService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowBindDataRepository flowBindDataRepository, FlowOperatorRepository flowOperatorRepository, FlowProcessRepository flowProcessRepository, FlowBackupRepository flowBackupRepository) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowBindDataRepository = flowBindDataRepository;
        this.flowOperatorRepository = flowOperatorRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.flowBackupRepository = flowBackupRepository;
    }
}

