/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.result;

import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.pojo.FlowResult;
import com.codingapi.springboot.flow.pojo.FlowSubmitResult;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class MessageResult {
    private String title;
    private List<Message> items;
    private boolean closeable;

    public MessageResult addItem(String label, String value) {
        if (this.items == null) {
            this.items = new ArrayList<Message>();
        }
        this.items.add(new Message(label, value));
        return this;
    }

    public MessageResult closeable(boolean closeable) {
        this.closeable = closeable;
        return this;
    }

    public static MessageResult create(FlowSubmitResult result) {
        List<? extends IFlowOperator> operators = result.getOperators();
        FlowNode flowNode = result.getFlowNode();
        MessageResult messageResult = new MessageResult();
        messageResult.setTitle("\u4e0b\u7ea7\u8282\u70b9\u63d0\u793a");
        messageResult.addItem("\u4e0b\u7ea7\u5ba1\u6279\u8282\u70b9", flowNode.getName());
        StringBuilder usernames = new StringBuilder();
        for (IFlowOperator iFlowOperator : operators) {
            usernames.append(iFlowOperator.getName()).append(",");
        }
        messageResult.addItem("\u4e0b\u7ea7\u5ba1\u6279\u4eba", usernames.toString());
        return messageResult;
    }

    public static MessageResult create(FlowResult result) {
        List<FlowRecord> records = result.getRecords();
        FlowWork flowWork = result.getFlowWork();
        MessageResult messageResult = new MessageResult();
        messageResult.setTitle("\u6d41\u7a0b\u5ba1\u6279\u5b8c\u6210");
        for (FlowRecord record : records) {
            FlowNode flowNode = flowWork.getNodeByCode(record.getNodeCode());
            messageResult.addItem("\u4e0b\u7ea7\u5ba1\u6279\u8282\u70b9", flowNode.getName());
            messageResult.addItem("\u4e0b\u7ea7\u5ba1\u6279\u4eba", record.getCurrentOperator().getName());
        }
        return messageResult;
    }

    public static MessageResult create(String title) {
        return MessageResult.create(title, null, false);
    }

    public static MessageResult create(String title, boolean closeable) {
        return MessageResult.create(title, null, closeable);
    }

    public static MessageResult create(String title, List<Message> items, boolean closeable) {
        MessageResult messageResult = new MessageResult();
        messageResult.setTitle(title);
        messageResult.setItems(items);
        messageResult.setCloseable(closeable);
        return messageResult;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setItems(List<Message> items) {
        this.items = items;
    }

    @Generated
    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public List<Message> getItems() {
        return this.items;
    }

    @Generated
    public boolean isCloseable() {
        return this.closeable;
    }

    public static class Message {
        private String label;
        private String value;

        @Generated
        public void setLabel(String label) {
            this.label = label;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public Message(String label, String value) {
            this.label = label;
            this.value = value;
        }
    }
}

