/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowButton;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.result.MessageResult;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowCustomEventService {
    private final FlowRecordRepository flowRecordRepository;
    private final FlowProcessRepository flowProcessRepository;

    public MessageResult customFlowEvent(long recordId, IFlowOperator currentOperator, String buttonId, IBindData bindData, Opinion opinion) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordSubmitState();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyChildrenRecordsIsEmpty();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowNode flowNode = flowRecordVerifyService.getFlowNode();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        List<Object> historyRecords = flowRecord.isStartRecord() ? new ArrayList() : this.flowRecordRepository.findFlowRecordByPreId(flowRecord.getPreId());
        IFlowOperator createOperator = flowRecord.getCreateOperator();
        FlowButton flowButton = flowNode.getButton(buttonId);
        if (flowButton == null) {
            throw new IllegalArgumentException("flow button not found");
        }
        if (!flowButton.isGroovy()) {
            throw new IllegalArgumentException("flow button not groovy");
        }
        return flowButton.run(flowRecord, flowNode, flowWork, createOperator, currentOperator, bindData, opinion, historyRecords);
    }

    @Generated
    public FlowCustomEventService(FlowRecordRepository flowRecordRepository, FlowProcessRepository flowProcessRepository) {
        this.flowRecordRepository = flowRecordRepository;
        this.flowProcessRepository = flowProcessRepository;
    }
}

