/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.pojo.FlowResult;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.service.FlowDirectionService;
import com.codingapi.springboot.flow.service.FlowNodeService;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowSubmitService {
    private final FlowRecordRepository flowRecordRepository;
    private final FlowBindDataRepository flowBindDataRepository;
    private final FlowOperatorRepository flowOperatorRepository;
    private final FlowProcessRepository flowProcessRepository;

    public FlowResult submitFlow(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        boolean next;
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordSubmitState();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyChildrenRecordsIsEmpty();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowNode flowNode = flowRecordVerifyService.getFlowNode();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        BindDataSnapshot snapshot = null;
        if (flowNode.isEditable()) {
            snapshot = new BindDataSnapshot(bindData);
            this.flowBindDataRepository.save(snapshot);
        } else {
            snapshot = this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        }
        FlowDirectionService flowDirectionService = new FlowDirectionService(flowRecordVerifyService.getFlowNode(), flowRecordVerifyService.getFlowWork(), opinion);
        flowDirectionService.loadFlowSourceDirection();
        flowDirectionService.verifyFlowSourceDirection();
        FlowSourceDirection flowSourceDirection = flowDirectionService.getFlowSourceDirection();
        flowRecord.submitRecord(currentOperator, snapshot, opinion, flowSourceDirection);
        this.flowRecordRepository.update(flowRecord);
        List<Object> historyRecords = flowRecord.isStartRecord() ? new ArrayList() : this.flowRecordRepository.findFlowRecordByPreId(flowRecord.getPreId());
        flowDirectionService.bindHistoryRecords(historyRecords);
        if (flowNode.isSign() && (next = flowDirectionService.hasCurrentFlowNodeIsDone())) {
            List<FlowRecord> todoRecords = historyRecords.stream().filter(FlowRecord::isTodo).toList();
            return new FlowResult(flowWork, todoRecords);
        }
        if (flowNode.isUnSign()) {
            for (FlowRecord record : historyRecords) {
                if (!record.isTodo() || record.getId() == flowRecord.getId()) continue;
                record.autoPass(currentOperator, snapshot);
                this.flowRecordRepository.update(flowRecord);
            }
        }
        flowSourceDirection = flowDirectionService.reloadFlowSourceDirection();
        IFlowOperator createOperator = flowRecord.getCreateOperator();
        FlowNodeService flowNodeService = new FlowNodeService(this.flowOperatorRepository, this.flowRecordRepository, snapshot, opinion, createOperator, currentOperator, historyRecords, flowWork, flowRecord, flowRecord.getProcessId(), flowRecord.getId());
        if (flowDirectionService.isPassRecord()) {
            flowNodeService.loadNextPassNode(flowNode);
        } else if (flowDirectionService.isDefaultBackRecord()) {
            flowNodeService.loadDefaultBackNode(flowRecord.getPreId());
        } else {
            flowNodeService.loadCustomBackNode(flowNode, flowRecord.getPreId());
        }
        List<FlowRecord> records = flowNodeService.createRecord();
        if (flowNodeService.nextNodeIsOver()) {
            flowRecord.submitRecord(currentOperator, snapshot, opinion, flowSourceDirection);
            flowRecord.finish();
            this.flowRecordRepository.update(flowRecord);
            this.flowRecordRepository.finishFlowRecordByProcessId(flowRecord.getProcessId());
            EventPusher.push((IEvent)new FlowApprovalEvent(6, flowRecord, currentOperator, flowWork, snapshot.toBindData()), (boolean)true);
            if (!records.isEmpty()) {
                return new FlowResult(flowWork, records.get(0));
            }
            return new FlowResult(flowWork, flowRecord);
        }
        this.flowRecordRepository.save(records);
        int eventState = flowSourceDirection == FlowSourceDirection.PASS ? 2 : 3;
        EventPusher.push((IEvent)new FlowApprovalEvent(eventState, flowRecord, currentOperator, flowWork, snapshot.toBindData()), (boolean)true);
        for (FlowRecord record : records) {
            IFlowOperator pushOperator = record.getCurrentOperator();
            EventPusher.push((IEvent)new FlowApprovalEvent(7, record, pushOperator, flowWork, snapshot.toBindData()), (boolean)true);
        }
        return new FlowResult(flowWork, records);
    }

    @Generated
    public FlowSubmitService(FlowRecordRepository flowRecordRepository, FlowBindDataRepository flowBindDataRepository, FlowOperatorRepository flowOperatorRepository, FlowProcessRepository flowProcessRepository) {
        this.flowRecordRepository = flowRecordRepository;
        this.flowBindDataRepository = flowBindDataRepository;
        this.flowOperatorRepository = flowOperatorRepository;
        this.flowProcessRepository = flowProcessRepository;
    }
}

