/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.content.FlowSession;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowTransferService {
    private final FlowRecordRepository flowRecordRepository;
    private final FlowBindDataRepository flowBindDataRepository;
    private final FlowProcessRepository flowProcessRepository;

    public void transfer(long recordId, IFlowOperator currentOperator, IFlowOperator targetOperator, IBindData bindData, String advice) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.loadFlowRecord();
        flowRecordVerifyService.verifyFlowRecordSubmitState();
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.verifyTargetOperatorIsNotCurrentOperator(targetOperator);
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyFlowRecordIsTodo();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        FlowNode flowNode = flowRecordVerifyService.getFlowNode();
        BindDataSnapshot snapshot = new BindDataSnapshot(bindData);
        this.flowBindDataRepository.save(snapshot);
        Opinion opinion = Opinion.transfer(advice);
        flowRecord.transfer(currentOperator, snapshot, opinion);
        this.flowRecordRepository.update(flowRecord);
        IFlowOperator createOperator = flowRecord.getCreateOperator();
        List<Object> historyRecords = flowRecord.isStartRecord() ? new ArrayList() : this.flowRecordRepository.findFlowRecordByPreId(flowRecord.getPreId());
        FlowSession content = new FlowSession(flowRecord, flowWork, flowNode, createOperator, targetOperator, snapshot.toBindData(), opinion, historyRecords);
        String generateTitle = flowNode.generateTitle(content);
        FlowRecord transferRecord = flowRecord.copy();
        transferRecord.transferToTodo(generateTitle, targetOperator);
        this.flowRecordRepository.save(List.of(transferRecord));
        EventPusher.push((IEvent)new FlowApprovalEvent(4, flowRecord, currentOperator, flowWork, snapshot.toBindData()), (boolean)true);
        EventPusher.push((IEvent)new FlowApprovalEvent(7, transferRecord, targetOperator, flowWork, snapshot.toBindData()), (boolean)true);
    }

    @Generated
    public FlowTransferService(FlowRecordRepository flowRecordRepository, FlowBindDataRepository flowBindDataRepository, FlowProcessRepository flowProcessRepository) {
        this.flowRecordRepository = flowRecordRepository;
        this.flowBindDataRepository = flowBindDataRepository;
        this.flowProcessRepository = flowProcessRepository;
    }
}

