/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.pojo;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.List;
import lombok.Generated;

public class FlowDetail {
    private final FlowRecord flowRecord;
    private final FlowWork flowWork;
    private final FlowNode flowNode;
    private final List<FlowRecord> historyRecords;
    private final IBindData bindData;
    private final List<? extends IFlowOperator> operators;
    private final IFlowOperator flowCreator;
    private final long flowCreateTime;
    private final List<FlowOpinion> opinions;

    public FlowDetail(FlowRecord flowRecord, BindDataSnapshot snapshot, FlowWork flowWork, List<FlowRecord> historyRecords, List<? extends IFlowOperator> operators) {
        this.operators = operators;
        this.flowRecord = flowRecord;
        this.flowWork = flowWork;
        this.bindData = snapshot.toBindData();
        this.historyRecords = historyRecords;
        this.opinions = historyRecords.stream().map(x$0 -> new FlowOpinion((FlowRecord)x$0)).toList();
        this.flowCreator = flowRecord.getCreateOperator();
        this.flowCreateTime = flowRecord.getCreateTime();
        this.flowNode = flowWork.getNodeByCode(flowRecord.getNodeCode());
    }

    @Generated
    public FlowRecord getFlowRecord() {
        return this.flowRecord;
    }

    @Generated
    public FlowWork getFlowWork() {
        return this.flowWork;
    }

    @Generated
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Generated
    public List<FlowRecord> getHistoryRecords() {
        return this.historyRecords;
    }

    @Generated
    public IBindData getBindData() {
        return this.bindData;
    }

    @Generated
    public List<? extends IFlowOperator> getOperators() {
        return this.operators;
    }

    @Generated
    public IFlowOperator getFlowCreator() {
        return this.flowCreator;
    }

    @Generated
    public long getFlowCreateTime() {
        return this.flowCreateTime;
    }

    @Generated
    public List<FlowOpinion> getOpinions() {
        return this.opinions;
    }

    public final class FlowOpinion {
        private final long recordId;
        private final Opinion opinion;
        private final IFlowOperator operator;
        private final long createTime;

        public FlowOpinion(FlowRecord flowRecord) {
            this.recordId = flowRecord.getId();
            this.opinion = flowRecord.getOpinion();
            this.operator = flowRecord.getCurrentOperator();
            this.createTime = flowRecord.getUpdateTime();
        }

        @Generated
        public long getRecordId() {
            return this.recordId;
        }

        @Generated
        public Opinion getOpinion() {
            return this.opinion;
        }

        @Generated
        public IFlowOperator getOperator() {
            return this.operator;
        }

        @Generated
        public long getCreateTime() {
            return this.createTime;
        }
    }
}

