/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.build;

import com.codingapi.springboot.flow.domain.FlowButton;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowRelation;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.em.ApprovalType;
import com.codingapi.springboot.flow.em.NodeType;
import com.codingapi.springboot.flow.error.ErrTrigger;
import com.codingapi.springboot.flow.generator.TitleGenerator;
import com.codingapi.springboot.flow.matcher.OperatorMatcher;
import com.codingapi.springboot.flow.trigger.OutTrigger;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.utils.RandomGenerator;
import java.util.List;

public class FlowWorkBuilder {
    private FlowWork work = null;

    private FlowWorkBuilder(FlowWork flowWork) {
        this.work = flowWork;
    }

    public static FlowWorkBuilder builder(IFlowOperator flowOperator) {
        return new FlowWorkBuilder(new FlowWork(flowOperator));
    }

    public FlowWorkBuilder description(String description) {
        this.work.setDescription(description);
        return this;
    }

    public FlowWorkBuilder postponedMax(int postponedMax) {
        this.work.setPostponedMax(postponedMax);
        return this;
    }

    public FlowWorkBuilder skipIfSameApprover(boolean skipIfSameApprover) {
        this.work.setSkipIfSameApprover(skipIfSameApprover);
        return this;
    }

    public FlowWorkBuilder title(String title) {
        this.work.setTitle(title);
        return this;
    }

    public FlowWorkBuilder schema(String schema) {
        this.work.schema(schema);
        return this;
    }

    public Nodes nodes() {
        return new Nodes();
    }

    public Relations relations() {
        return new Relations();
    }

    public FlowWork build() {
        this.work.enable();
        return this.work;
    }

    public class Nodes {
        public Nodes node(String id, String name, String code, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher, long timeout, TitleGenerator titleGenerator, ErrTrigger errTrigger, boolean editable, List<FlowButton> buttons) {
            FlowNode node = new FlowNode(id, name, code, view, NodeType.parser(code), approvalType, titleGenerator, operatorMatcher, timeout, errTrigger, editable, buttons);
            FlowWorkBuilder.this.work.addNode(node);
            return this;
        }

        public Nodes node(String name, String code, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher, long timeout, boolean editable) {
            return this.node(RandomGenerator.generateUUID(), name, code, view, approvalType, operatorMatcher, timeout, TitleGenerator.defaultTitleGenerator(), null, editable, null);
        }

        public Nodes node(String name, String code, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher, long timeout, boolean editable, List<FlowButton> buttons) {
            return this.node(RandomGenerator.generateUUID(), name, code, view, approvalType, operatorMatcher, timeout, TitleGenerator.defaultTitleGenerator(), null, editable, buttons);
        }

        public Nodes node(String name, String code, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher, boolean editable) {
            return this.node(RandomGenerator.generateUUID(), name, code, view, approvalType, operatorMatcher, 0L, TitleGenerator.defaultTitleGenerator(), null, editable, null);
        }

        public Nodes node(String name, String code, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher, boolean editable, List<FlowButton> buttons) {
            return this.node(RandomGenerator.generateUUID(), name, code, view, approvalType, operatorMatcher, 0L, TitleGenerator.defaultTitleGenerator(), null, editable, buttons);
        }

        public Nodes node(String name, String code, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher, List<FlowButton> buttons) {
            return this.node(name, code, view, approvalType, operatorMatcher, true, buttons);
        }

        public Nodes node(String name, String code, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher) {
            return this.node(name, code, view, approvalType, operatorMatcher, true, null);
        }

        public Nodes node(String name, String code, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher, ErrTrigger errTrigger, boolean editable, List<FlowButton> buttons) {
            return this.node(RandomGenerator.generateUUID(), name, code, view, approvalType, operatorMatcher, 0L, TitleGenerator.defaultTitleGenerator(), errTrigger, editable, buttons);
        }

        public Nodes node(String name, String code, String view, ApprovalType approvalType, OperatorMatcher operatorMatcher, ErrTrigger errTrigger, boolean editable) {
            return this.node(RandomGenerator.generateUUID(), name, code, view, approvalType, operatorMatcher, 0L, TitleGenerator.defaultTitleGenerator(), errTrigger, editable, null);
        }

        public Relations relations() {
            return new Relations();
        }

        public FlowWork build() {
            FlowWorkBuilder.this.work.enable();
            return FlowWorkBuilder.this.work;
        }
    }

    public class Relations {
        public Relations relation(String name, String source, String target) {
            return this.relation(name, source, target, OutTrigger.defaultOutTrigger(), 1, false);
        }

        public Relations relation(String name, String source, String target, OutTrigger outTrigger, int order, boolean back) {
            FlowNode from = FlowWorkBuilder.this.work.getNodeByCode(source);
            FlowNode to = FlowWorkBuilder.this.work.getNodeByCode(target);
            FlowRelation relation = new FlowRelation(RandomGenerator.generateUUID(), name, from, to, outTrigger, order, back);
            FlowWorkBuilder.this.work.addRelation(relation);
            return this;
        }

        public FlowWork build() {
            FlowWorkBuilder.this.work.enable();
            return FlowWorkBuilder.this.work;
        }
    }
}

