/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.generator;

import com.codingapi.springboot.flow.content.FlowSession;
import com.codingapi.springboot.flow.script.GroovyShellContext;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class TitleGenerator {
    private final String script;
    private final GroovyShellContext.ShellScript runtime;

    public TitleGenerator(String script) {
        if (!StringUtils.hasLength((String)script)) {
            throw new IllegalArgumentException("script is empty");
        }
        this.script = script;
        this.runtime = GroovyShellContext.getInstance().parse(script);
    }

    public static TitleGenerator defaultTitleGenerator() {
        return new TitleGenerator("def run(content){ return content.getCurrentOperator().getName() + '-' + content.getFlowWork().getTitle() + '-' + content.getFlowNode().getName();}");
    }

    public String generate(FlowSession flowSession) {
        return (String)this.runtime.invokeMethod("run", flowSession);
    }

    @Generated
    public String getScript() {
        return this.script;
    }
}

