/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.content;

import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.content.FlowSessionBeanProvider;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.error.NodeResult;
import com.codingapi.springboot.flow.error.OperatorResult;
import com.codingapi.springboot.flow.pojo.FlowResult;
import com.codingapi.springboot.flow.pojo.FlowSubmitResult;
import com.codingapi.springboot.flow.query.FlowRecordQuery;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.result.MessageResult;
import com.codingapi.springboot.flow.service.FlowService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.List;
import lombok.Generated;

public class FlowSession {
    private final FlowRecord flowRecord;
    private final FlowWork flowWork;
    private final FlowNode flowNode;
    private final IFlowOperator createOperator;
    private final IFlowOperator currentOperator;
    private final IBindData bindData;
    private final Opinion opinion;
    private final List<FlowRecord> historyRecords;
    private final FlowSessionBeanProvider provider;

    public FlowSession(FlowRecord flowRecord, FlowWork flowWork, FlowNode flowNode, IFlowOperator createOperator, IFlowOperator currentOperator, IBindData bindData, Opinion opinion, List<FlowRecord> historyRecords) {
        this.flowRecord = flowRecord;
        this.flowWork = flowWork;
        this.flowNode = flowNode;
        this.createOperator = createOperator;
        this.currentOperator = currentOperator;
        this.bindData = bindData;
        this.opinion = opinion;
        this.historyRecords = historyRecords;
        this.provider = FlowSessionBeanProvider.getInstance();
    }

    public Object getBean(String beanName) {
        return this.provider.getBean(beanName);
    }

    public <T> T getBean(Class<T> clazz) {
        return this.provider.getBean(clazz);
    }

    public String getAdvice() {
        if (this.opinion != null) {
            return this.opinion.getAdvice();
        }
        return null;
    }

    public NodeResult createNodeErrTrigger(String nodeCode) {
        return new NodeResult(nodeCode);
    }

    public OperatorResult createOperatorErrTrigger(List<Long> operatorIds) {
        return new OperatorResult(operatorIds);
    }

    public OperatorResult createOperatorErrTrigger(long ... operatorIds) {
        return new OperatorResult(operatorIds);
    }

    public MessageResult createMessageResult(String title, String resultState) {
        return MessageResult.create(title, resultState);
    }

    public MessageResult createMessageResult(String title) {
        return MessageResult.create(title);
    }

    public MessageResult createMessageResult(String title, String resultState, boolean closeable) {
        return MessageResult.create(title, resultState, closeable);
    }

    public MessageResult createMessageResult(String title, String resultState, List<MessageResult.Message> items, boolean closeable) {
        return MessageResult.create(title, resultState, items, closeable);
    }

    public MessageResult submitFlow() {
        if (this.flowRecord == null) {
            throw new IllegalArgumentException("flow record is null");
        }
        FlowService flowService = this.loadFlowService();
        FlowResult result = flowService.submitFlow(this.flowRecord.getId(), this.currentOperator, this.bindData, Opinion.pass(this.opinion.getAdvice()));
        return MessageResult.create(result);
    }

    public MessageResult rejectFlow() {
        if (this.flowRecord == null) {
            throw new IllegalArgumentException("flow record is null");
        }
        FlowService flowService = this.loadFlowService();
        FlowResult result = flowService.submitFlow(this.flowRecord.getId(), this.currentOperator, this.bindData, Opinion.reject(this.opinion.getAdvice()));
        return MessageResult.create(result);
    }

    public boolean backStateIsReject() {
        if (this.flowRecord == null) {
            return false;
        }
        long preId = this.flowRecord.getPreId();
        if (preId == 0L) {
            return false;
        }
        FlowRecordQuery flowRecordQuery = this.getBean(FlowRecordQuery.class);
        FlowRecord preRecord = flowRecordQuery.getFlowRecordById(preId);
        if (preRecord != null) {
            return preRecord.getFlowSourceDirection() == FlowSourceDirection.REJECT;
        }
        return false;
    }

    @Deprecated
    public boolean isRejectState() {
        return this.backStateIsReject();
    }

    public boolean currentStateIsReject() {
        if (this.flowRecord != null) {
            return this.flowRecord.getFlowSourceDirection() == FlowSourceDirection.REJECT;
        }
        return false;
    }

    public MessageResult trySubmitFlow() {
        if (this.flowRecord == null) {
            throw new IllegalArgumentException("flow record is null");
        }
        FlowService flowService = this.loadFlowService();
        FlowSubmitResult result = flowService.trySubmitFlow(this.flowRecord.getId(), this.currentOperator, this.bindData, Opinion.pass(this.opinion.getAdvice()));
        return MessageResult.create(result);
    }

    public void saveFlow() {
        if (this.flowRecord == null) {
            throw new IllegalArgumentException("flow record is null");
        }
        FlowService flowService = this.loadFlowService();
        flowService.save(this.flowRecord.getId(), this.currentOperator, this.bindData, this.opinion.getAdvice());
    }

    public void urgeFlow() {
        if (this.flowRecord == null) {
            throw new IllegalArgumentException("flow record is null");
        }
        FlowService flowService = this.loadFlowService();
        flowService.urge(this.flowRecord.getId(), this.currentOperator);
    }

    public void recallFlow() {
        if (this.flowRecord == null) {
            throw new IllegalArgumentException("flow record is null");
        }
        FlowService flowService = this.loadFlowService();
        flowService.recall(this.flowRecord.getId(), this.currentOperator);
    }

    private FlowService loadFlowService() {
        return (FlowService)this.getBean("flowService");
    }

    @Generated
    public FlowRecord getFlowRecord() {
        return this.flowRecord;
    }

    @Generated
    public FlowWork getFlowWork() {
        return this.flowWork;
    }

    @Generated
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Generated
    public IFlowOperator getCreateOperator() {
        return this.createOperator;
    }

    @Generated
    public IFlowOperator getCurrentOperator() {
        return this.currentOperator;
    }

    @Generated
    public IBindData getBindData() {
        return this.bindData;
    }

    @Generated
    public Opinion getOpinion() {
        return this.opinion;
    }

    @Generated
    public List<FlowRecord> getHistoryRecords() {
        return this.historyRecords;
    }

    @Generated
    public FlowSessionBeanProvider getProvider() {
        return this.provider;
    }
}

