/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.serializable;

import com.codingapi.springboot.flow.domain.FlowButton;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.em.ApprovalType;
import com.codingapi.springboot.flow.em.FlowButtonType;
import com.codingapi.springboot.flow.em.NodeType;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.serializable.FlowNodeSerializable;
import com.codingapi.springboot.flow.serializable.FlowRelationSerializable;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class FlowWorkSerializable
implements Serializable {
    private long id;
    private String code;
    private String title;
    private String description;
    private long createUser;
    private long createTime;
    private long updateTime;
    private boolean enable;
    private boolean skipIfSameApprover;
    private int postponedMax;
    private String schema;
    private List<FlowNodeSerializable> nodes;
    private List<FlowRelationSerializable> relations;

    public byte[] toSerializable() {
        Kryo kryo = new Kryo();
        kryo.register(ArrayList.class);
        kryo.register(FlowNodeSerializable.class);
        kryo.register(FlowRelationSerializable.class);
        kryo.register(FlowWorkSerializable.class);
        kryo.register(ApprovalType.class);
        kryo.register(NodeType.class);
        kryo.register(FlowButton.class);
        kryo.register(FlowButtonType.class);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)outputStream);
        kryo.writeObject(output, (Object)this);
        output.close();
        return outputStream.toByteArray();
    }

    public static FlowWorkSerializable fromSerializable(byte[] bytes) {
        Kryo kryo = new Kryo();
        kryo.register(ArrayList.class);
        kryo.register(FlowNodeSerializable.class);
        kryo.register(FlowRelationSerializable.class);
        kryo.register(FlowWorkSerializable.class);
        kryo.register(ApprovalType.class);
        kryo.register(NodeType.class);
        kryo.register(FlowButton.class);
        kryo.register(FlowButtonType.class);
        return (FlowWorkSerializable)kryo.readObject(new Input(bytes), FlowWorkSerializable.class);
    }

    public FlowWork toFlowWork(FlowOperatorRepository flowOperatorRepository) {
        List<FlowNode> flowNodes = this.nodes.stream().map(FlowNodeSerializable::toFlowNode).toList();
        return new FlowWork(this.id, this.code, this.title, this.description, flowOperatorRepository.getFlowOperatorById(this.createUser), this.createTime, this.updateTime, this.enable, this.skipIfSameApprover, this.postponedMax, flowNodes, this.relations.stream().map(item -> item.toFlowRelation(flowNodes)).toList(), this.schema);
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setCreateUser(long createUser) {
        this.createUser = createUser;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Generated
    public void setNodes(List<FlowNodeSerializable> nodes) {
        this.nodes = nodes;
    }

    @Generated
    public void setRelations(List<FlowRelationSerializable> relations) {
        this.relations = relations;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public long getCreateUser() {
        return this.createUser;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public boolean isSkipIfSameApprover() {
        return this.skipIfSameApprover;
    }

    @Generated
    public int getPostponedMax() {
        return this.postponedMax;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public List<FlowNodeSerializable> getNodes() {
        return this.nodes;
    }

    @Generated
    public List<FlowRelationSerializable> getRelations() {
        return this.relations;
    }

    @Generated
    public FlowWorkSerializable() {
    }

    @Generated
    public FlowWorkSerializable(long id, String code, String title, String description, long createUser, long createTime, long updateTime, boolean enable, boolean skipIfSameApprover, int postponedMax, String schema, List<FlowNodeSerializable> nodes, List<FlowRelationSerializable> relations) {
        this.id = id;
        this.code = code;
        this.title = title;
        this.description = description;
        this.createUser = createUser;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.enable = enable;
        this.skipIfSameApprover = skipIfSameApprover;
        this.postponedMax = postponedMax;
        this.schema = schema;
        this.nodes = nodes;
        this.relations = relations;
    }

    @Generated
    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    @Generated
    public void setSkipIfSameApprover(boolean skipIfSameApprover) {
        this.skipIfSameApprover = skipIfSameApprover;
    }

    @Generated
    public void setPostponedMax(int postponedMax) {
        this.postponedMax = postponedMax;
    }
}

