/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.pojo.FlowStepResult;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.service.FlowNodeService;
import com.codingapi.springboot.flow.service.FlowServiceRepositoryHolder;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.ArrayList;

public class FlowStepService {
    private final FlowWork flowWork;
    private final IFlowOperator currentOperator;
    private final IBindData bindData;
    private final FlowServiceRepositoryHolder flowServiceRepositoryHolder;
    private FlowNodeService flowNodeService;
    private FlowNode flowNode;

    public FlowStepService(String workCode, IFlowOperator currentOperator, IBindData bindData, FlowServiceRepositoryHolder flowServiceRepositoryHolder) {
        this.currentOperator = currentOperator;
        this.bindData = bindData;
        this.flowServiceRepositoryHolder = flowServiceRepositoryHolder;
        this.flowWork = flowServiceRepositoryHolder.getFlowWorkRepository().getFlowWorkByCode(workCode);
    }

    public FlowStepResult getFlowStep() {
        FlowStepResult flowStepResult = new FlowStepResult();
        FlowNode start = this.flowWork.getStartNode();
        if (start == null) {
            throw new IllegalArgumentException("start node not found");
        }
        this.flowNode = start;
        long preId = 0L;
        String processId = "flow_" + System.currentTimeMillis();
        ArrayList<FlowRecord> historyRecords = new ArrayList<FlowRecord>();
        FlowOperatorRepository flowOperatorRepository = this.flowServiceRepositoryHolder.getFlowOperatorRepository();
        FlowRecordRepository flowRecordRepository = this.flowServiceRepositoryHolder.getFlowRecordRepository();
        BindDataSnapshot snapshot = new BindDataSnapshot(this.bindData);
        this.flowNodeService = new FlowNodeService(flowOperatorRepository, flowRecordRepository, snapshot, Opinion.pass("\u540c\u610f"), this.currentOperator, this.currentOperator, historyRecords, this.flowWork, null, processId, preId);
        this.flowNodeService.setNextNode(start);
        this.flowNode = start;
        flowStepResult.addFlowNode(this.flowNode, this.flowNodeService.loadNextNodeOperators());
        do {
            this.flowNodeService.loadNextPassNode(this.flowNode);
            this.flowNode = this.flowNodeService.getNextNode();
            flowStepResult.addFlowNode(this.flowNode, this.flowNodeService.loadNextNodeOperators());
        } while (!this.flowNode.isOverNode());
        return flowStepResult;
    }
}

