/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.pojo.FlowResult;
import com.codingapi.springboot.flow.record.FlowBackup;
import com.codingapi.springboot.flow.record.FlowProcess;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBackupRepository;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowNodeService;
import com.codingapi.springboot.flow.service.FlowServiceRepositoryHolder;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowStartService {
    private final String workCode;
    private final IFlowOperator operator;
    private final IBindData bindData;
    private final Opinion opinion;
    private final FlowServiceRepositoryHolder flowServiceRepositoryHolder;
    private FlowWork flowWork;
    private FlowNode flowNode;
    private FlowBackup flowBackup;
    private FlowProcess flowProcess;
    private BindDataSnapshot snapshot;
    private FlowNodeService flowNodeService;

    public FlowStartService(String workCode, IFlowOperator operator, IBindData bindData, String advice, FlowServiceRepositoryHolder flowServiceRepositoryHolder) {
        this.workCode = workCode;
        this.operator = operator;
        this.bindData = bindData;
        this.opinion = Opinion.pass(advice);
        this.flowServiceRepositoryHolder = flowServiceRepositoryHolder;
    }

    private void loadFlowWork() {
        FlowWorkRepository flowWorkRepository = this.flowServiceRepositoryHolder.getFlowWorkRepository();
        this.flowWork = flowWorkRepository.getFlowWorkByCode(this.workCode);
        if (this.flowWork == null) {
            throw new IllegalArgumentException("flow work not found");
        }
        this.flowWork.verify();
        this.flowWork.enableValidate();
    }

    private synchronized void loadFlowBackup() {
        FlowBackupRepository flowBackupRepository = this.flowServiceRepositoryHolder.getFlowBackupRepository();
        this.flowBackup = flowBackupRepository.getFlowBackupByWorkIdAndVersion(this.flowWork.getId(), this.flowWork.getUpdateTime());
        if (this.flowBackup == null) {
            this.flowBackup = flowBackupRepository.backup(this.flowWork);
        }
    }

    private void saveFlowProcess() {
        this.flowProcess = new FlowProcess(this.flowBackup.getId(), this.operator);
        this.flowServiceRepositoryHolder.getFlowProcessRepository().save(this.flowProcess);
    }

    private void saveBindDataSnapshot() {
        this.snapshot = new BindDataSnapshot(this.bindData);
        this.flowServiceRepositoryHolder.getFlowBindDataRepository().save(this.snapshot);
    }

    private void buildFlowNodeService() {
        FlowNode start = this.flowWork.getStartNode();
        if (start == null) {
            throw new IllegalArgumentException("start node not found");
        }
        this.flowNode = start;
        long preId = 0L;
        String processId = this.flowProcess.getProcessId();
        ArrayList<FlowRecord> historyRecords = new ArrayList<FlowRecord>();
        FlowOperatorRepository flowOperatorRepository = this.flowServiceRepositoryHolder.getFlowOperatorRepository();
        FlowRecordRepository flowRecordRepository = this.flowServiceRepositoryHolder.getFlowRecordRepository();
        this.flowNodeService = new FlowNodeService(flowOperatorRepository, flowRecordRepository, this.snapshot, this.opinion, this.operator, this.operator, historyRecords, this.flowWork, null, processId, preId);
        this.flowNodeService.setNextNode(start);
    }

    private void pushEvent(int flowApprovalEventState, FlowRecord flowRecord) {
        EventPusher.push((IEvent)new FlowApprovalEvent(flowApprovalEventState, flowRecord, flowRecord.getCurrentOperator(), this.flowWork, this.snapshot.toBindData()), (boolean)true);
    }

    private void saveFlowRecords(List<FlowRecord> flowRecords) {
        FlowRecordRepository flowRecordRepository = this.flowServiceRepositoryHolder.getFlowRecordRepository();
        flowRecordRepository.save(flowRecords);
    }

    public FlowResult startFlow() {
        this.loadFlowWork();
        this.loadFlowBackup();
        this.saveFlowProcess();
        this.saveBindDataSnapshot();
        this.buildFlowNodeService();
        List<FlowRecord> records = this.flowNodeService.createRecord();
        if (records.isEmpty()) {
            throw new IllegalArgumentException("flow record not found");
        }
        for (FlowRecord record : records) {
            record.updateOpinion(this.opinion);
        }
        if (this.flowNodeService.nextNodeIsOver()) {
            for (FlowRecord record : records) {
                record.submitRecord(this.operator, this.snapshot, this.opinion, FlowSourceDirection.PASS);
                record.finish();
            }
            this.saveFlowRecords(records);
            for (FlowRecord record : records) {
                this.pushEvent(1, record);
                this.pushEvent(6, record);
            }
            return new FlowResult(this.flowWork, records);
        }
        this.saveFlowRecords(records);
        for (FlowRecord record : records) {
            this.pushEvent(1, record);
            this.pushEvent(7, record);
            this.pushEvent(10, record);
        }
        return new FlowResult(this.flowWork, records);
    }

    public FlowRecord tryStartFlow() {
        this.loadFlowWork();
        this.loadFlowBackup();
        this.snapshot = new BindDataSnapshot(this.bindData);
        this.flowProcess = new FlowProcess(this.flowBackup.getId(), this.operator);
        this.buildFlowNodeService();
        FlowRecord startRecord = null;
        List<FlowRecord> records = this.flowNodeService.createRecord();
        if (records.isEmpty()) {
            throw new IllegalArgumentException("flow record not found");
        }
        for (FlowRecord record : records) {
            record.updateOpinion(this.opinion);
            startRecord = record;
        }
        if (this.flowNodeService.nextNodeIsOver()) {
            for (FlowRecord record : records) {
                record.submitRecord(this.operator, this.snapshot, this.opinion, FlowSourceDirection.PASS);
                record.finish();
                startRecord = record;
            }
        }
        return startRecord;
    }

    @Generated
    public FlowWork getFlowWork() {
        return this.flowWork;
    }
}

