/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.pojo.FlowStepResult;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.service.FlowNodeService;
import com.codingapi.springboot.flow.service.FlowServiceRepositoryHolder;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.utils.RandomGenerator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FlowStepService {
    private final FlowWork flowWork;
    private final long recordId;
    private final List<FlowRecord> flowRecords;
    private final IFlowOperator currentOperator;
    private final IBindData bindData;
    private final FlowServiceRepositoryHolder flowServiceRepositoryHolder;
    private FlowNodeService flowNodeService;
    private FlowNode flowNode;
    private FlowRecord currentFlowRecord;

    public FlowStepService(long recordId, String workCode, IFlowOperator currentOperator, IBindData bindData, FlowServiceRepositoryHolder flowServiceRepositoryHolder) {
        this.recordId = recordId;
        this.currentOperator = currentOperator;
        this.bindData = bindData;
        this.flowServiceRepositoryHolder = flowServiceRepositoryHolder;
        if (this.recordId > 0L) {
            this.currentFlowRecord = flowServiceRepositoryHolder.getFlowRecordRepository().getFlowRecordById(recordId);
            this.flowRecords = flowServiceRepositoryHolder.getFlowRecordRepository().findFlowRecordByProcessId(this.currentFlowRecord.getProcessId()).stream().sorted(Comparator.comparingLong(FlowRecord::getId)).toList();
            this.flowWork = flowServiceRepositoryHolder.getFlowWorkRepository().getFlowWorkByCode(this.currentFlowRecord.getWorkCode());
        } else {
            this.currentFlowRecord = null;
            this.flowRecords = new ArrayList<FlowRecord>();
            this.flowWork = flowServiceRepositoryHolder.getFlowWorkRepository().getFlowWorkByCode(workCode);
        }
    }

    public FlowStepResult getFlowStep() {
        FlowStepResult flowStepResult = new FlowStepResult();
        long preId = 0L;
        if (this.currentFlowRecord == null) {
            FlowNode start = this.flowWork.getStartNode();
            if (start == null) {
                throw new IllegalArgumentException("start node not found");
            }
            preId = 0L;
            this.flowNode = start;
        } else {
            for (FlowRecord flowRecord : this.flowRecords) {
                FlowNode flowNode = this.flowWork.getNodeByCode(flowRecord.getNodeCode());
                ArrayList<IFlowOperator> operators = new ArrayList<IFlowOperator>();
                if (flowRecord.getCurrentOperator() != null) {
                    operators.add(flowRecord.getCurrentOperator());
                }
                boolean isDone = flowRecord.isDone() || flowRecord.getOpinion().isCirculate();
                flowStepResult.addFlowNode(flowNode, isDone, operators);
            }
            FlowRecord lastRecord = this.flowRecords.get(this.flowRecords.size() - 1);
            this.flowNode = this.flowWork.getNodeByCode(lastRecord.getNodeCode());
            preId = lastRecord.getId();
        }
        String processId = "flow_" + RandomGenerator.generateUUID();
        FlowOperatorRepository flowOperatorRepository = this.flowServiceRepositoryHolder.getFlowOperatorRepository();
        FlowRecordRepository flowRecordRepository = this.flowServiceRepositoryHolder.getFlowRecordRepository();
        ArrayList<FlowRecord> historyRecords = new ArrayList<FlowRecord>();
        BindDataSnapshot snapshot = new BindDataSnapshot(this.bindData);
        this.flowNodeService = new FlowNodeService(flowOperatorRepository, flowRecordRepository, snapshot, Opinion.pass("\u540c\u610f"), this.currentOperator, this.currentOperator, historyRecords, this.flowWork, null, processId, preId);
        this.flowNodeService.setNextNode(this.flowNode);
        if (this.currentFlowRecord == null) {
            flowStepResult.addFlowNode(this.flowNode, false, this.flowNodeService.loadNextNodeOperators());
        }
        do {
            this.flowNodeService.loadNextPassNode(this.flowNode);
            this.flowNode = this.flowNodeService.getNextNode();
            boolean isFinish = this.currentFlowRecord != null && this.currentFlowRecord.isFinish();
            flowStepResult.addFlowNode(this.flowNode, isFinish, this.flowNodeService.loadNextNodeOperators());
        } while (!this.flowNode.isOverNode());
        return flowStepResult;
    }
}

