/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.service.FlowServiceRepositoryHolder;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowStopService {
    private final IFlowOperator currentOperator;
    private final FlowRecordVerifyService flowRecordVerifyService;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowBindDataRepository flowBindDataRepository;
    private FlowRecord flowRecord;
    private FlowWork flowWork;
    private FlowNode flowNode;
    private BindDataSnapshot snapshot;

    public FlowStopService(long recordId, IFlowOperator currentOperator, FlowServiceRepositoryHolder flowServiceRepositoryHolder) {
        this.currentOperator = currentOperator;
        this.flowRecordRepository = flowServiceRepositoryHolder.getFlowRecordRepository();
        this.flowBindDataRepository = flowServiceRepositoryHolder.getFlowBindDataRepository();
        this.flowRecordVerifyService = new FlowRecordVerifyService(flowServiceRepositoryHolder.getFlowWorkRepository(), flowServiceRepositoryHolder.getFlowRecordRepository(), flowServiceRepositoryHolder.getFlowProcessRepository(), recordId, currentOperator);
    }

    private void loadFlow() {
        this.flowRecordVerifyService.verifyFlowRecordSubmitState();
        this.flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        this.flowRecordVerifyService.loadFlowWork();
        this.flowRecordVerifyService.loadFlowNode();
        this.flowRecordVerifyService.verifyChildrenRecordsIsEmpty();
        this.flowRecord = this.flowRecordVerifyService.getFlowRecord();
        this.flowNode = this.flowRecordVerifyService.getFlowNode();
        this.flowWork = this.flowRecordVerifyService.getFlowWork();
        this.snapshot = this.flowBindDataRepository.getBindDataSnapshotById(this.flowRecord.getSnapshotId());
    }

    public void stop() {
        this.loadFlow();
        this.flowRecord.stop();
        this.flowRecordRepository.update(this.flowRecord);
        List<FlowRecord> todoRecords = this.flowRecordRepository.findFlowRecordByProcessId(this.flowRecord.getProcessId());
        for (FlowRecord record : todoRecords) {
            if (!record.isTodo()) continue;
            record.stop();
            this.flowRecordRepository.update(record);
        }
        this.flowRecordRepository.finishFlowRecordByProcessId(this.flowRecord.getProcessId());
        EventPusher.push((IEvent)new FlowApprovalEvent(14, this.flowRecord, this.flowRecord.getCurrentOperator(), this.flowWork, this.snapshot.toBindData()), (boolean)true);
    }
}

