/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.record.FlowProcess;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowBackService {
    private final FlowWorkRepository flowWorkRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowProcessRepository flowProcessRepository;
    private final FlowBindDataRepository flowBindDataRepository;

    public void back(String processId, String backNodeCode, IFlowOperator currentOperator) {
        if (!currentOperator.isFlowManager()) {
            throw new IllegalArgumentException("current operator not flow manager");
        }
        FlowProcess flowProcess = this.flowProcessRepository.getFlowProcessByProcessId(processId);
        if (flowProcess.isVoided()) {
            throw new IllegalArgumentException("flow process already voided");
        }
        List<FlowRecord> historyRecords = this.flowRecordRepository.findFlowRecordByProcessId(processId).stream().sorted(Comparator.comparingLong(FlowRecord::getId)).toList();
        for (FlowRecord flowRecord : historyRecords) {
            if (!flowRecord.isFinish()) continue;
            throw new IllegalArgumentException("flow record already finish");
        }
        if (historyRecords.isEmpty()) {
            throw new IllegalArgumentException("flow record not found");
        }
        List<String> historyNodeCodes = historyRecords.stream().map(FlowRecord::getNodeCode).distinct().toList();
        if (!historyNodeCodes.contains(backNodeCode)) {
            throw new IllegalArgumentException("flow node code not found");
        }
        FlowRecord beginRecord = historyRecords.get(0);
        for (FlowRecord flowRecord : historyRecords) {
            if (!flowRecord.getNodeCode().equals(backNodeCode)) continue;
            beginRecord = flowRecord;
        }
        for (FlowRecord flowRecord : historyRecords) {
            if (flowRecord.getId() > beginRecord.getId()) {
                flowRecord.delete();
                continue;
            }
            if (!flowRecord.getNodeCode().equals(beginRecord.getNodeCode())) continue;
            flowRecord.recall();
        }
        this.flowRecordRepository.save(historyRecords);
        FlowWork flowWork = this.flowWorkRepository.getFlowWorkByCode(beginRecord.getWorkCode());
        IBindData bindData = this.flowBindDataRepository.getBindDataSnapshotById(beginRecord.getSnapshotId()).toBindData();
        EventPusher.push((IEvent)new FlowApprovalEvent(12, beginRecord, currentOperator, flowWork, bindData), (boolean)true);
    }

    @Generated
    public FlowBackService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowProcessRepository flowProcessRepository, FlowBindDataRepository flowBindDataRepository) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.flowBindDataRepository = flowBindDataRepository;
    }
}

