/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service;

import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.user.IFlowOperator;
import java.util.List;
import lombok.Generated;

public class FlowRecordVerifyService {
    private final IFlowOperator currentOperator;
    final FlowRecordRepository flowRecordRepository;
    final FlowProcessRepository flowProcessRepository;
    final FlowWorkRepository flowWorkRepository;
    private FlowWork flowWork;
    private FlowNode flowNode;
    private final FlowRecord flowRecord;

    public FlowRecordVerifyService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowProcessRepository flowProcessRepository, long recordId, IFlowOperator currentOperator) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.currentOperator = currentOperator;
        FlowRecord flowRecord = flowRecordRepository.getFlowRecordById(recordId);
        if (flowRecord == null) {
            throw new IllegalArgumentException("flow record not found");
        }
        this.flowRecord = flowRecord;
    }

    public FlowRecordVerifyService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowProcessRepository flowProcessRepository, FlowRecord flowRecord, FlowWork flowWork, IFlowOperator currentOperator) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.currentOperator = currentOperator;
        this.flowRecord = flowRecord;
        this.flowWork = flowWork;
    }

    public void verifyFlowRecordSubmitState() {
        this.flowRecord.submitStateVerify();
    }

    public void verifyFlowRecordCurrentOperator() {
        if (!this.currentOperator.isFlowManager()) {
            this.flowRecord.matcherOperator(this.currentOperator);
        }
    }

    public boolean isCreateOperator() {
        return this.flowRecord.isCreateOperator(this.currentOperator);
    }

    public void verifyFlowRecordNotDone() {
        if (this.flowRecord.isDone()) {
            throw new IllegalArgumentException("flow record is done");
        }
    }

    public void verifyFlowRecordIsDone() {
        if (!this.flowRecord.isDone()) {
            throw new IllegalArgumentException("flow record is not done");
        }
    }

    public void verifyFlowRecordNotTodo() {
        if (this.flowRecord.isTodo() && !this.flowRecord.isStartRecord()) {
            throw new IllegalArgumentException("flow record is todo");
        }
    }

    public void verifyFlowRecordIsTodo() {
        if (!this.flowRecord.isTodo()) {
            throw new IllegalArgumentException("flow record is not todo");
        }
    }

    public void verifyFlowRecordNotFinish() {
        if (this.flowRecord.isFinish()) {
            throw new IllegalArgumentException("flow record is finish");
        }
    }

    public void verifyFlowNodeEditableState(boolean editable) {
        if (this.flowNode.isEditable() == editable) {
            throw new IllegalArgumentException("flow node is not editable");
        }
    }

    public void verifyTargetOperatorIsNotCurrentOperator(IFlowOperator targetOperator) {
        if (this.currentOperator.getUserId() == targetOperator.getUserId()) {
            throw new IllegalArgumentException("current operator is target operator");
        }
    }

    public void loadFlowWork() {
        if (this.flowWork == null) {
            FlowWork flowWork = this.flowProcessRepository.getFlowWorkByProcessId(this.flowRecord.getProcessId());
            if (flowWork == null) {
                flowWork = this.flowWorkRepository.getFlowWorkByCode(this.flowRecord.getWorkCode());
            }
            if (flowWork == null) {
                throw new IllegalArgumentException("flow work not found");
            }
            flowWork.enableValidate();
            this.flowWork = flowWork;
        }
    }

    public void loadFlowNode() {
        FlowNode flowNode = this.flowWork.getNodeByCode(this.flowRecord.getNodeCode());
        if (flowNode == null) {
            throw new IllegalArgumentException("flow node not found");
        }
        this.flowNode = flowNode;
    }

    public void setFlowRecordRead() {
        if (this.currentOperator != null && this.flowRecord.isOperator(this.currentOperator) && !this.flowRecord.isRead()) {
            this.flowRecord.read();
            this.flowRecordRepository.setReadRecord(this.flowRecord.getId());
        }
    }

    public void verifyChildrenRecordsIsEmpty() {
        List<FlowRecord> childrenRecords = this.flowRecordRepository.findFlowRecordByPreId(this.flowRecord.getId());
        if (!childrenRecords.isEmpty()) {
            throw new IllegalArgumentException("flow node is done");
        }
    }

    @Generated
    public IFlowOperator getCurrentOperator() {
        return this.currentOperator;
    }

    @Generated
    public FlowWork getFlowWork() {
        return this.flowWork;
    }

    @Generated
    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Generated
    public FlowRecord getFlowRecord() {
        return this.flowRecord;
    }
}

