/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.List;
import lombok.Generated;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowRecallService {
    private final FlowWorkRepository flowWorkRepository;
    private final FlowRecordRepository flowRecordRepository;
    private final FlowProcessRepository flowProcessRepository;
    private final FlowBindDataRepository flowBindDataRepository;

    public void recall(long recordId, IFlowOperator currentOperator, boolean backStartNode) {
        FlowRecordVerifyService flowRecordVerifyService = new FlowRecordVerifyService(this.flowWorkRepository, this.flowRecordRepository, this.flowProcessRepository, recordId, currentOperator);
        flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        flowRecordVerifyService.loadFlowWork();
        flowRecordVerifyService.loadFlowNode();
        flowRecordVerifyService.verifyFlowRecordNotFinish();
        flowRecordVerifyService.verifyFlowRecordNotTodo();
        FlowRecord flowRecord = flowRecordVerifyService.getFlowRecord();
        FlowWork flowWork = flowRecordVerifyService.getFlowWork();
        BindDataSnapshot bindDataSnapshot = this.flowBindDataRepository.getBindDataSnapshotById(flowRecord.getSnapshotId());
        if (backStartNode && flowRecordVerifyService.isCreateOperator()) {
            List<FlowRecord> records = this.flowRecordRepository.findFlowRecordByProcessId(flowRecord.getProcessId());
            for (FlowRecord record : records) {
                if (!record.isStartRecord()) {
                    record.delete();
                    this.flowRecordRepository.update(record);
                    continue;
                }
                record.recall();
                flowRecord = record;
                this.flowRecordRepository.update(record);
            }
        } else {
            List<FlowRecord> childrenRecords = this.flowRecordRepository.findFlowRecordByPreId(recordId);
            if (childrenRecords.isEmpty()) {
                throw new IllegalArgumentException("flow record not submit");
            }
            boolean allUnDone = childrenRecords.stream().allMatch(item -> item.isUnRead() && item.isTodo());
            if (!allUnDone) {
                throw new IllegalArgumentException("flow record not recall");
            }
            flowRecord.recall();
            this.flowRecordRepository.update(flowRecord);
            for (FlowRecord childrenRecord : childrenRecords) {
                childrenRecord.delete();
            }
            this.flowRecordRepository.save(childrenRecords);
        }
        IBindData bindData = bindDataSnapshot.toBindData();
        EventPusher.push((IEvent)new FlowApprovalEvent(5, flowRecord, currentOperator, flowWork, bindData), (boolean)true);
    }

    public void recall(long recordId, IFlowOperator currentOperator) {
        this.recall(recordId, currentOperator, true);
    }

    @Generated
    public FlowRecallService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowProcessRepository flowProcessRepository, FlowBindDataRepository flowBindDataRepository) {
        this.flowWorkRepository = flowWorkRepository;
        this.flowRecordRepository = flowRecordRepository;
        this.flowProcessRepository = flowProcessRepository;
        this.flowBindDataRepository = flowBindDataRepository;
    }
}

