/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service;

import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.pojo.FlowDetail;
import com.codingapi.springboot.flow.pojo.FlowResult;
import com.codingapi.springboot.flow.pojo.FlowStepResult;
import com.codingapi.springboot.flow.pojo.FlowSubmitResult;
import com.codingapi.springboot.flow.repository.FlowBackupRepository;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowOperatorRepository;
import com.codingapi.springboot.flow.repository.FlowProcessRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.repository.FlowWorkRepository;
import com.codingapi.springboot.flow.result.MessageResult;
import com.codingapi.springboot.flow.service.FlowServiceRepositoryHolder;
import com.codingapi.springboot.flow.service.impl.FlowBackService;
import com.codingapi.springboot.flow.service.impl.FlowCustomEventService;
import com.codingapi.springboot.flow.service.impl.FlowDetailService;
import com.codingapi.springboot.flow.service.impl.FlowNotifyService;
import com.codingapi.springboot.flow.service.impl.FlowPostponedService;
import com.codingapi.springboot.flow.service.impl.FlowRecallService;
import com.codingapi.springboot.flow.service.impl.FlowRemoveService;
import com.codingapi.springboot.flow.service.impl.FlowSaveService;
import com.codingapi.springboot.flow.service.impl.FlowStartService;
import com.codingapi.springboot.flow.service.impl.FlowStepService;
import com.codingapi.springboot.flow.service.impl.FlowSubmitService;
import com.codingapi.springboot.flow.service.impl.FlowTransferService;
import com.codingapi.springboot.flow.service.impl.FlowTrySubmitService;
import com.codingapi.springboot.flow.service.impl.FlowUrgeService;
import com.codingapi.springboot.flow.service.impl.FlowVoidedService;
import com.codingapi.springboot.flow.user.IFlowOperator;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
public class FlowService {
    private final FlowDetailService flowDetailService;
    private final FlowCustomEventService flowCustomEventService;
    private final FlowRecallService flowRecallService;
    private final FlowRemoveService flowRemoveService;
    private final FlowSaveService flowSaveService;
    private final FlowTransferService flowTransferService;
    private final FlowPostponedService flowPostponedService;
    private final FlowUrgeService flowUrgeService;
    private final FlowVoidedService flowVoidedService;
    private final FlowBackService flowBackService;
    private final FlowServiceRepositoryHolder flowServiceRepositoryHolder;

    public FlowService(FlowWorkRepository flowWorkRepository, FlowRecordRepository flowRecordRepository, FlowBindDataRepository flowBindDataRepository, FlowOperatorRepository flowOperatorRepository, FlowProcessRepository flowProcessRepository, FlowBackupRepository flowBackupRepository) {
        this.flowServiceRepositoryHolder = new FlowServiceRepositoryHolder(flowWorkRepository, flowRecordRepository, flowBindDataRepository, flowOperatorRepository, flowProcessRepository, flowBackupRepository);
        this.flowDetailService = new FlowDetailService(flowWorkRepository, flowRecordRepository, flowBindDataRepository, flowOperatorRepository, flowProcessRepository);
        this.flowCustomEventService = new FlowCustomEventService(flowWorkRepository, flowRecordRepository, flowProcessRepository);
        this.flowRecallService = new FlowRecallService(flowWorkRepository, flowRecordRepository, flowProcessRepository, flowBindDataRepository);
        this.flowRemoveService = new FlowRemoveService(flowWorkRepository, flowRecordRepository, flowProcessRepository, flowBindDataRepository);
        this.flowSaveService = new FlowSaveService(flowWorkRepository, flowRecordRepository, flowBindDataRepository, flowProcessRepository);
        this.flowTransferService = new FlowTransferService(flowWorkRepository, flowRecordRepository, flowBindDataRepository, flowProcessRepository);
        this.flowPostponedService = new FlowPostponedService(flowWorkRepository, flowRecordRepository, flowProcessRepository);
        this.flowUrgeService = new FlowUrgeService(flowWorkRepository, flowRecordRepository, flowProcessRepository);
        this.flowVoidedService = new FlowVoidedService(flowWorkRepository, flowRecordRepository, flowProcessRepository, flowBindDataRepository);
        this.flowBackService = new FlowBackService(flowWorkRepository, flowRecordRepository, flowProcessRepository, flowBindDataRepository);
    }

    public FlowDetail detail(long recordId, String workCode, IFlowOperator currentOperator) {
        if (recordId > 0L) {
            return this.flowDetailService.detail(recordId, currentOperator);
        }
        if (StringUtils.hasText((String)workCode)) {
            return this.flowDetailService.detail(workCode, currentOperator);
        }
        return null;
    }

    public FlowDetail detail(long recordId, IFlowOperator currentOperator) {
        return this.detail(recordId, null, currentOperator);
    }

    public FlowDetail detail(String workCode, IFlowOperator currentOperator) {
        return this.detail(0L, workCode, currentOperator);
    }

    public FlowDetail detail(long recordId) {
        return this.detail(recordId, null, null);
    }

    public void postponed(long recordId, IFlowOperator currentOperator, long time) {
        this.flowPostponedService.postponed(recordId, currentOperator, time);
    }

    public void urge(long recordId, IFlowOperator currentOperator) {
        this.flowUrgeService.urge(recordId, currentOperator);
    }

    public FlowResult interfere(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        if (!currentOperator.isFlowManager()) {
            throw new IllegalArgumentException("current operator is not flow manager");
        }
        return this.submitFlow(recordId, currentOperator, bindData, opinion);
    }

    public void transfer(long recordId, IFlowOperator currentOperator, IFlowOperator targetOperator, IBindData bindData, String advice) {
        this.flowTransferService.transfer(recordId, currentOperator, targetOperator, bindData, advice);
    }

    public void save(long recordId, IFlowOperator currentOperator, IBindData bindData, String advice) {
        this.flowSaveService.save(recordId, currentOperator, bindData, advice);
    }

    public FlowResult startFlow(String workCode, IFlowOperator operator, IBindData bindData, String advice) {
        FlowStartService flowStartService = new FlowStartService(workCode, operator, bindData, advice, this.flowServiceRepositoryHolder);
        return flowStartService.startFlow();
    }

    public FlowSubmitResult trySubmitFlow(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        FlowTrySubmitService flowTrySubmitService = new FlowTrySubmitService(currentOperator, bindData, opinion, this.flowServiceRepositoryHolder);
        return flowTrySubmitService.trySubmitFlow(recordId);
    }

    public FlowStepResult getFlowStep(long recordId, IBindData bindData, IFlowOperator currentOperator) {
        FlowStepService flowStepService = new FlowStepService(recordId, null, currentOperator, bindData, this.flowServiceRepositoryHolder);
        return flowStepService.getFlowStep();
    }

    public FlowStepResult getFlowStep(String workCode, IBindData bindData, IFlowOperator currentOperator) {
        FlowStepService flowStepService = new FlowStepService(0L, workCode, currentOperator, bindData, this.flowServiceRepositoryHolder);
        return flowStepService.getFlowStep();
    }

    public FlowSubmitResult trySubmitFlow(String workCode, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        FlowTrySubmitService flowTrySubmitService = new FlowTrySubmitService(currentOperator, bindData, opinion, this.flowServiceRepositoryHolder);
        return flowTrySubmitService.trySubmitFlow(workCode);
    }

    public FlowResult submitFlow(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion) {
        FlowSubmitService flowSubmitService = new FlowSubmitService(recordId, currentOperator, bindData, opinion, this.flowServiceRepositoryHolder);
        return flowSubmitService.submitFlow();
    }

    public void notifyFlow(String processId, IFlowOperator currentOperator) {
        FlowNotifyService flowNotifyService = new FlowNotifyService(processId, currentOperator, this.flowServiceRepositoryHolder);
        flowNotifyService.notifyFlow();
    }

    public MessageResult customFlowEvent(long recordId, IFlowOperator currentOperator, String buttonId, IBindData bindData, Opinion opinion) {
        return this.flowCustomEventService.customFlowEvent(recordId, currentOperator, buttonId, bindData, opinion);
    }

    public void recall(long recordId, IFlowOperator currentOperator) {
        this.flowRecallService.recall(recordId, currentOperator);
    }

    public void remove(long recordId, IFlowOperator currentOperator) {
        this.flowRemoveService.remove(recordId, currentOperator);
    }

    public void voided(String processId, IFlowOperator currentOperator) {
        this.flowVoidedService.voided(processId, currentOperator);
    }

    public void back(String processId, String backNodeCode, IFlowOperator currentOperator) {
        this.flowBackService.back(processId, backNodeCode, currentOperator);
    }
}

