/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.flow.service.impl;

import com.codingapi.springboot.flow.bind.BindDataSnapshot;
import com.codingapi.springboot.flow.bind.IBindData;
import com.codingapi.springboot.flow.domain.FlowNode;
import com.codingapi.springboot.flow.domain.FlowWork;
import com.codingapi.springboot.flow.domain.Opinion;
import com.codingapi.springboot.flow.em.FlowSourceDirection;
import com.codingapi.springboot.flow.event.FlowApprovalEvent;
import com.codingapi.springboot.flow.pojo.FlowResult;
import com.codingapi.springboot.flow.pojo.FlowSubmitResult;
import com.codingapi.springboot.flow.record.FlowRecord;
import com.codingapi.springboot.flow.repository.FlowBindDataRepository;
import com.codingapi.springboot.flow.repository.FlowRecordRepository;
import com.codingapi.springboot.flow.service.FlowDirectionService;
import com.codingapi.springboot.flow.service.FlowNodeService;
import com.codingapi.springboot.flow.service.FlowRecordVerifyService;
import com.codingapi.springboot.flow.service.FlowServiceRepositoryHolder;
import com.codingapi.springboot.flow.user.IFlowOperator;
import com.codingapi.springboot.framework.event.EventPusher;
import com.codingapi.springboot.framework.event.IEvent;
import java.util.ArrayList;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FlowSubmitService {
    private final IFlowOperator currentOperator;
    private final IBindData bindData;
    private final Opinion opinion;
    private final FlowServiceRepositoryHolder flowServiceRepositoryHolder;
    private final FlowRecordVerifyService flowRecordVerifyService;
    private FlowRecord flowRecord;
    private FlowWork flowWork;
    private FlowNode flowNode;
    private FlowNode nextNode;
    private BindDataSnapshot snapshot;
    private FlowNodeService flowNodeService;
    private FlowDirectionService flowDirectionService;
    private FlowSourceDirection flowSourceDirection;

    public FlowSubmitService(long recordId, IFlowOperator currentOperator, IBindData bindData, Opinion opinion, FlowServiceRepositoryHolder flowServiceRepositoryHolder) {
        this.flowServiceRepositoryHolder = flowServiceRepositoryHolder;
        this.currentOperator = currentOperator;
        this.bindData = bindData;
        this.opinion = opinion;
        this.flowRecordVerifyService = new FlowRecordVerifyService(flowServiceRepositoryHolder.getFlowWorkRepository(), flowServiceRepositoryHolder.getFlowRecordRepository(), flowServiceRepositoryHolder.getFlowProcessRepository(), recordId, currentOperator);
    }

    public FlowSubmitService(FlowRecord flowRecord, FlowWork flowWork, IFlowOperator currentOperator, IBindData bindData, Opinion opinion, FlowServiceRepositoryHolder flowServiceRepositoryHolder) {
        this.flowWork = flowWork;
        this.flowServiceRepositoryHolder = flowServiceRepositoryHolder;
        this.currentOperator = currentOperator;
        this.bindData = bindData;
        this.opinion = opinion;
        this.flowRecordVerifyService = new FlowRecordVerifyService(flowServiceRepositoryHolder.getFlowWorkRepository(), flowServiceRepositoryHolder.getFlowRecordRepository(), flowServiceRepositoryHolder.getFlowProcessRepository(), flowRecord, flowWork, currentOperator);
    }

    private void loadFlow(boolean testSubmit) {
        this.flowRecordVerifyService.verifyFlowRecordSubmitState();
        this.flowRecordVerifyService.verifyFlowRecordCurrentOperator();
        this.flowRecordVerifyService.loadFlowWork();
        this.flowRecordVerifyService.loadFlowNode();
        this.flowRecordVerifyService.verifyChildrenRecordsIsEmpty();
        this.flowRecord = testSubmit ? this.flowRecordVerifyService.getFlowRecord().copy() : this.flowRecordVerifyService.getFlowRecord();
        this.flowNode = this.flowRecordVerifyService.getFlowNode();
        this.flowWork = this.flowRecordVerifyService.getFlowWork();
    }

    private void saveSnapshot(boolean testSubmit) {
        FlowBindDataRepository flowBindDataRepository = this.flowServiceRepositoryHolder.getFlowBindDataRepository();
        if (this.flowNode.isEditable()) {
            this.snapshot = new BindDataSnapshot(this.bindData);
            if (!testSubmit) {
                flowBindDataRepository.save(this.snapshot);
            }
        } else {
            this.snapshot = flowBindDataRepository.getBindDataSnapshotById(this.flowRecord.getSnapshotId());
        }
    }

    private void loadFlowDirection() {
        this.flowDirectionService = new FlowDirectionService(this.flowRecordVerifyService.getFlowNode(), this.flowRecordVerifyService.getFlowWork(), this.opinion);
        this.flowDirectionService.loadFlowSourceDirection();
        this.flowDirectionService.verifyFlowSourceDirection();
        this.flowSourceDirection = this.flowDirectionService.getFlowSourceDirection();
    }

    private List<FlowRecord> loadHistoryRecords(boolean testSubmit) {
        List<FlowRecord> historyRecords;
        FlowRecordRepository flowRecordRepository = this.flowServiceRepositoryHolder.getFlowRecordRepository();
        if (this.flowRecord.isStartRecord()) {
            historyRecords = new ArrayList<FlowRecord>();
        } else if (testSubmit) {
            historyRecords = flowRecordRepository.findFlowRecordByPreId(this.flowRecord.getPreId()).stream().map(FlowRecord::copy).toList();
            for (FlowRecord record : historyRecords) {
                if (record.getId() != this.flowRecord.getId()) continue;
                record.submitRecord(this.currentOperator, this.snapshot, this.opinion, this.flowSourceDirection);
            }
        } else {
            historyRecords = flowRecordRepository.findFlowRecordByPreId(this.flowRecord.getPreId());
        }
        return historyRecords;
    }

    private void saveFlowRecord(FlowRecord flowRecord) {
        FlowRecordRepository flowRecordRepository = this.flowServiceRepositoryHolder.getFlowRecordRepository();
        flowRecordRepository.update(flowRecord);
    }

    private void loadNextNode(List<FlowRecord> historyRecords) {
        IFlowOperator createOperator = this.flowRecord.getCreateOperator();
        this.flowNodeService = new FlowNodeService(this.flowServiceRepositoryHolder.getFlowOperatorRepository(), this.flowServiceRepositoryHolder.getFlowRecordRepository(), this.snapshot, this.opinion, createOperator, this.currentOperator, historyRecords, this.flowWork, this.flowRecord, this.flowRecord.getProcessId(), this.flowRecord.getId());
        if (this.flowDirectionService.isPassRecord()) {
            this.flowNodeService.loadNextPassNode(this.flowNode);
        } else if (this.flowDirectionService.isDefaultBackRecord()) {
            this.flowNodeService.loadDefaultBackNode(this.flowRecord);
        } else {
            this.flowNodeService.loadCustomBackNode(this.flowNode, this.flowRecord.getPreId());
        }
        this.nextNode = this.flowNodeService.getNextNode();
    }

    private void updateFinishFlowRecord() {
        this.flowServiceRepositoryHolder.getFlowRecordRepository().finishFlowRecordByProcessId(this.flowRecord.getProcessId());
    }

    private void saveNextFlowRecords(List<FlowRecord> flowRecords) {
        this.flowServiceRepositoryHolder.getFlowRecordRepository().save(flowRecords);
    }

    private void pushEvent(FlowRecord flowRecord, int eventState) {
        EventPusher.push((IEvent)new FlowApprovalEvent(eventState, flowRecord, flowRecord.getCurrentOperator(), this.flowWork, this.snapshot.toBindData()), (boolean)true);
    }

    public FlowResult submitFlow() {
        FlowResult flowResult = this.submitCurrentFlow();
        if (this.isSkipIfSameApprover() && !flowResult.isOver() && !flowResult.isStart()) {
            List<FlowRecord> flowRecords = flowResult.matchRecordByOperator(this.currentOperator);
            FlowResult result = flowResult;
            if (!flowRecords.isEmpty()) {
                for (FlowRecord flowRecord : flowRecords) {
                    FlowSubmitService flowSubmitService = new FlowSubmitService(flowRecord.getId(), this.currentOperator, this.bindData, this.opinion, this.flowServiceRepositoryHolder);
                    result = flowSubmitService.submitFlow();
                }
            }
            return result;
        }
        return flowResult;
    }

    private FlowResult submitCurrentFlow() {
        boolean isDone;
        this.loadFlow(false);
        this.saveSnapshot(false);
        this.loadFlowDirection();
        this.flowRecord.submitRecord(this.currentOperator, this.snapshot, this.opinion, this.flowSourceDirection);
        this.saveFlowRecord(this.flowRecord);
        List<FlowRecord> historyRecords = this.loadHistoryRecords(false);
        this.flowDirectionService.bindHistoryRecords(historyRecords);
        if (this.flowNode.isSign() && !(isDone = this.flowDirectionService.hasCurrentFlowNodeIsDone())) {
            List<FlowRecord> todoRecords = historyRecords.stream().filter(FlowRecord::isTodo).toList();
            return new FlowResult(this.flowWork, todoRecords);
        }
        if (this.flowNode.isUnSign()) {
            for (FlowRecord record : historyRecords) {
                if (!record.isTodo() || record.getId() == this.flowRecord.getId()) continue;
                record.autoPass(record.getCurrentOperator(), this.snapshot);
                FlowRecordRepository flowRecordRepository = this.flowServiceRepositoryHolder.getFlowRecordRepository();
                flowRecordRepository.update(record);
            }
        }
        this.flowSourceDirection = this.flowDirectionService.reloadFlowSourceDirection();
        this.loadNextNode(historyRecords);
        List<FlowRecord> nextRecords = this.flowNodeService.createRecord();
        if (this.flowNodeService.nextNodeIsOver()) {
            this.flowRecord.submitRecord(this.currentOperator, this.snapshot, this.opinion, this.flowSourceDirection);
            this.flowRecord.finish();
            this.saveFlowRecord(this.flowRecord);
            this.updateFinishFlowRecord();
            this.pushEvent(this.flowRecord, 6);
            if (!nextRecords.isEmpty()) {
                return new FlowResult(this.flowWork, nextRecords.get(0));
            }
            return new FlowResult(this.flowWork, this.flowRecord);
        }
        this.saveNextFlowRecords(nextRecords);
        int eventState = this.flowSourceDirection == FlowSourceDirection.PASS ? 2 : 3;
        this.pushEvent(this.flowRecord, eventState);
        for (FlowRecord record : nextRecords) {
            if (!record.isTodo()) continue;
            this.pushEvent(record, 7);
        }
        return new FlowResult(this.flowWork, nextRecords);
    }

    public FlowSubmitResult trySubmitFlow() {
        boolean isDone;
        this.loadFlow(true);
        this.saveSnapshot(true);
        this.loadFlowDirection();
        this.flowRecord.submitRecord(this.currentOperator, this.snapshot, this.opinion, this.flowSourceDirection);
        List<FlowRecord> historyRecords = this.loadHistoryRecords(true);
        this.flowDirectionService.bindHistoryRecords(historyRecords);
        if (this.flowNode.isSign() && !(isDone = this.flowDirectionService.hasCurrentFlowNodeIsDone())) {
            List<FlowRecord> todoRecords = historyRecords.stream().filter(FlowRecord::isTodo).toList();
            return new FlowSubmitResult(this.flowWork, this.flowNode, todoRecords.stream().map(FlowRecord::getCurrentOperator).toList());
        }
        if (this.flowNode.isUnSign()) {
            for (FlowRecord record : historyRecords) {
                if (!record.isTodo() || record.getId() == this.flowRecord.getId()) continue;
                record.autoPass(this.currentOperator, this.snapshot);
            }
        }
        this.flowSourceDirection = this.flowDirectionService.reloadFlowSourceDirection();
        this.loadNextNode(historyRecords);
        while (this.nextNode.isCirculate()) {
            this.flowNodeService.skipCirculate();
            this.nextNode = this.flowNodeService.getNextNode();
        }
        List<? extends IFlowOperator> operators = this.flowNodeService.loadNextNodeOperators();
        return new FlowSubmitResult(this.flowWork, this.nextNode, operators);
    }

    public boolean isSkipIfSameApprover() {
        return this.flowWork.isSkipIfSameApprover() && !this.nextNode.isOverNode();
    }
}

