/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.leaf;

import com.codingapi.springboot.leaf.EnableLeaf;
import com.codingapi.springboot.leaf.LeafContext;
import com.codingapi.springboot.leaf.LeafIdGenerate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public class AutoConfigurationImportSelector
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(AutoConfigurationImportSelector.class);
    private Set<Class<? extends LeafIdGenerate>> classes;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        String className = importingClassMetadata.getClassName();
        ArrayList<String> packageNames = new ArrayList<String>();
        try {
            packageNames.add(Class.forName(className).getPackage().getName());
            Map annotations = importingClassMetadata.getAnnotationAttributes(EnableLeaf.class.getName());
            assert (annotations != null);
            String[] packages = (String[])annotations.get("scanBasePackages");
            packageNames.addAll(Arrays.asList(packages));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(packageNames.toArray(new String[0])).addScanners(new Scanner[]{Scanners.TypesAnnotated, Scanners.SubTypes}));
        this.classes = reflections.getSubTypesOf(LeafIdGenerate.class);
        log.debug("classes:{}", this.classes);
        LeafContext.getInstance().setClasses(this.classes);
    }
}

