/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.leaf;

import com.codingapi.springboot.leaf.LeafContext;
import com.codingapi.springboot.leaf.exception.LeafServerException;
import com.codingapi.springboot.leaf.exception.NoKeyException;
import com.codingapi.springboot.leaf.properties.LeafProperties;
import com.sankuai.inf.leaf.IDGen;
import com.sankuai.inf.leaf.common.Result;
import com.sankuai.inf.leaf.common.Status;
import com.sankuai.inf.leaf.segment.dao.IDAllocDao;
import com.sankuai.inf.leaf.segment.model.LeafAlloc;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Leaf {
    private static final Logger log = LoggerFactory.getLogger(Leaf.class);
    private final IDGen idGen;
    private final IDAllocDao idAllocDao;
    private final LeafProperties leafProperties;

    long segmentGetId(String key) {
        Result result = this.idGen.get(key);
        if (key == null || key.isEmpty()) {
            throw new NoKeyException();
        }
        if (result.getStatus().equals((Object)Status.EXCEPTION)) {
            throw new LeafServerException(result.toString());
        }
        return result.getId();
    }

    boolean segmentPush(String key, int step, int maxId) {
        LeafAlloc alloc = new LeafAlloc();
        alloc.setKey(key);
        alloc.setStep(step);
        alloc.setMaxId(maxId);
        alloc.setUpdateTime(new Date());
        return this.idAllocDao.save(alloc);
    }

    void initIdGen() {
        this.idGen.init();
    }

    void init() {
        LeafContext.getInstance().setLeaf(this, this.leafProperties);
    }

    public Leaf(IDGen idGen, IDAllocDao idAllocDao, LeafProperties leafProperties) {
        this.idGen = idGen;
        this.idAllocDao = idAllocDao;
        this.leafProperties = leafProperties;
    }
}

