/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.leaf;

import com.codingapi.springboot.leaf.Leaf;
import com.codingapi.springboot.leaf.LeafIdGenerate;
import com.codingapi.springboot.leaf.exception.LeafServerException;
import com.codingapi.springboot.leaf.properties.LeafProperties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LeafContext {
    private static final Logger log = LoggerFactory.getLogger(LeafContext.class);
    private Leaf leaf;
    private int defaultStep;
    private int defaultMaxId;
    private Set<Class<? extends LeafIdGenerate>> classes;
    private static LeafContext instance;

    private LeafContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LeafContext getInstance() {
        if (instance != null) return instance;
        Class<LeafContext> clazz = LeafContext.class;
        synchronized (LeafContext.class) {
            if (instance != null) return instance;
            instance = new LeafContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected void setLeaf(Leaf leaf, LeafProperties leafProperties) {
        this.leaf = leaf;
        this.defaultMaxId = leafProperties.getDefaultMaxId();
        this.defaultStep = leafProperties.getDefaultStep();
        this.initClass();
    }

    long generateId(Class<?> clazz) {
        return this.segmentGetId(clazz);
    }

    long segmentGetId(Class<?> clazz) {
        return this.leaf.segmentGetId(clazz.getName());
    }

    public void push(String key, int step, int maxId) {
        this.leaf.segmentPush(key, step, maxId);
    }

    private void initClass() {
        if (this.classes != null && this.classes.size() > 0) {
            for (Class<? extends LeafIdGenerate> clazz : this.classes) {
                try {
                    LeafContext.getInstance().push(clazz.getName(), this.defaultStep, this.defaultMaxId);
                }
                catch (Exception e) {
                    throw new LeafServerException(e);
                }
            }
        }
        this.leaf.initIdGen();
        log.info("leaf init finish.");
    }

    public void setClasses(Set<Class<? extends LeafIdGenerate>> classes) {
        this.classes = classes;
    }
}

