/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.inf.leaf.segment;

import com.sankuai.inf.leaf.IDGen;
import com.sankuai.inf.leaf.common.Result;
import com.sankuai.inf.leaf.common.Status;
import com.sankuai.inf.leaf.segment.dao.IDAllocDao;
import com.sankuai.inf.leaf.segment.model.LeafAlloc;
import com.sankuai.inf.leaf.segment.model.Segment;
import com.sankuai.inf.leaf.segment.model.SegmentBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentIDGenImpl
implements IDGen {
    private static final Logger logger = LoggerFactory.getLogger(SegmentIDGenImpl.class);
    private static final long EXCEPTION_ID_IDCACHE_INIT_FALSE = -1L;
    private static final long EXCEPTION_ID_KEY_NOT_EXISTS = -2L;
    private static final long EXCEPTION_ID_TWO_SEGMENTS_ARE_NULL = -3L;
    private static final int MAX_STEP = 1000000;
    private static final long SEGMENT_DURATION = 900000L;
    private final ExecutorService service = new ThreadPoolExecutor(5, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new UpdateThreadFactory());
    private volatile boolean initOK = false;
    private final Map<String, SegmentBuffer> cache = new ConcurrentHashMap<String, SegmentBuffer>();
    private IDAllocDao dao;

    public SegmentIDGenImpl(IDAllocDao dao) {
        this.dao = dao;
    }

    @Override
    public boolean init() {
        logger.info("Init ...");
        this.updateCacheFromDb();
        this.initOK = true;
        this.updateCacheFromDbAtEveryMinute();
        return this.initOK;
    }

    private void updateCacheFromDbAtEveryMinute() {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("check-idCache-thread");
                t.setDaemon(true);
                return t;
            }
        });
        service.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SegmentIDGenImpl.this.updateCacheFromDb();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheFromDb() {
        logger.info("update cache from db");
        Slf4JStopWatch sw = new Slf4JStopWatch();
        try {
            String tmp;
            List<String> dbTags = this.dao.getAllTags();
            if (dbTags == null || dbTags.isEmpty()) {
                return;
            }
            ArrayList<String> cacheTags = new ArrayList<String>(this.cache.keySet());
            HashSet<String> insertTagsSet = new HashSet<String>(dbTags);
            HashSet<String> removeTagsSet = new HashSet<String>(cacheTags);
            for (int i = 0; i < cacheTags.size(); ++i) {
                tmp = (String)cacheTags.get(i);
                if (!insertTagsSet.contains(tmp)) continue;
                insertTagsSet.remove(tmp);
            }
            for (String tag : insertTagsSet) {
                SegmentBuffer buffer = new SegmentBuffer();
                buffer.setKey(tag);
                Segment segment = buffer.getCurrent();
                segment.setValue(new AtomicLong(0L));
                segment.setMax(0L);
                segment.setStep(0);
                this.cache.put(tag, buffer);
                logger.info("Add tag {} from db to IdCache, SegmentBuffer {}", (Object)tag, (Object)buffer);
            }
            for (int i = 0; i < dbTags.size(); ++i) {
                tmp = dbTags.get(i);
                if (!removeTagsSet.contains(tmp)) continue;
                removeTagsSet.remove(tmp);
            }
            for (String tag : removeTagsSet) {
                this.cache.remove(tag);
                logger.info("Remove tag {} from IdCache", (Object)tag);
            }
        }
        catch (Exception e) {
            logger.warn("update cache from db exception", (Throwable)e);
        }
        finally {
            sw.stop("updateCacheFromDb");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result get(String key) {
        if (!this.initOK) {
            return new Result(-1L, Status.EXCEPTION);
        }
        if (this.cache.containsKey(key)) {
            SegmentBuffer buffer = this.cache.get(key);
            if (!buffer.isInitOk()) {
                SegmentBuffer segmentBuffer = buffer;
                synchronized (segmentBuffer) {
                    if (!buffer.isInitOk()) {
                        try {
                            this.updateSegmentFromDb(key, buffer.getCurrent());
                            logger.info("Init buffer. Update leafkey {} {} from db", (Object)key, (Object)buffer.getCurrent());
                            buffer.setInitOk(true);
                        }
                        catch (Exception e) {
                            logger.warn("Init buffer {} exception", (Object)buffer.getCurrent(), (Object)e);
                        }
                    }
                }
            }
            return this.getIdFromSegmentBuffer(this.cache.get(key));
        }
        return new Result(-2L, Status.EXCEPTION);
    }

    public void updateSegmentFromDb(String key, Segment segment) {
        LeafAlloc leafAlloc;
        Slf4JStopWatch sw = new Slf4JStopWatch();
        SegmentBuffer buffer = segment.getBuffer();
        if (!buffer.isInitOk()) {
            leafAlloc = this.dao.updateMaxIdAndGetLeafAlloc(key);
            buffer.setStep(leafAlloc.getStep());
            buffer.setMinStep(leafAlloc.getStep());
        } else if (buffer.getUpdateTimestamp() == 0L) {
            leafAlloc = this.dao.updateMaxIdAndGetLeafAlloc(key);
            buffer.setUpdateTimestamp(System.currentTimeMillis());
            buffer.setStep(leafAlloc.getStep());
            buffer.setMinStep(leafAlloc.getStep());
        } else {
            long duration = System.currentTimeMillis() - buffer.getUpdateTimestamp();
            int nextStep = buffer.getStep();
            if (duration < 900000L) {
                if (nextStep * 2 <= 1000000) {
                    nextStep *= 2;
                }
            } else if (duration >= 1800000L) {
                nextStep = nextStep / 2 >= buffer.getMinStep() ? nextStep / 2 : nextStep;
            }
            logger.info("leafKey[{}], step[{}], duration[{}mins], nextStep[{}]", new Object[]{key, buffer.getStep(), String.format("%.2f", (double)duration / 60000.0), nextStep});
            LeafAlloc temp = new LeafAlloc();
            temp.setKey(key);
            temp.setStep(nextStep);
            leafAlloc = this.dao.updateMaxIdByCustomStepAndGetLeafAlloc(temp);
            buffer.setUpdateTimestamp(System.currentTimeMillis());
            buffer.setStep(nextStep);
            buffer.setMinStep(leafAlloc.getStep());
        }
        long value = leafAlloc.getMaxId() - (long)buffer.getStep();
        segment.getValue().set(value);
        segment.setMax(leafAlloc.getMaxId());
        segment.setStep(buffer.getStep());
        sw.stop("updateSegmentFromDb", key + " " + segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getIdFromSegmentBuffer(final SegmentBuffer buffer) {
        while (true) {
            long value;
            Segment segment;
            buffer.rLock().lock();
            try {
                segment = buffer.getCurrent();
                if (!buffer.isNextReady() && (double)segment.getIdle() < 0.9 * (double)segment.getStep() && buffer.getThreadRunning().compareAndSet(false, true)) {
                    this.service.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Segment next = buffer.getSegments()[buffer.nextPos()];
                            boolean updateOk = false;
                            try {
                                SegmentIDGenImpl.this.updateSegmentFromDb(buffer.getKey(), next);
                                updateOk = true;
                                logger.info("update segment {} from db {}", (Object)buffer.getKey(), (Object)next);
                            }
                            catch (Exception e) {
                                logger.warn(buffer.getKey() + " updateSegmentFromDb exception", (Throwable)e);
                            }
                            finally {
                                if (updateOk) {
                                    buffer.wLock().lock();
                                    buffer.setNextReady(true);
                                    buffer.getThreadRunning().set(false);
                                    buffer.wLock().unlock();
                                } else {
                                    buffer.getThreadRunning().set(false);
                                }
                            }
                        }
                    });
                }
                if ((value = segment.getValue().getAndIncrement()) < segment.getMax()) {
                    Result result = new Result(value, Status.SUCCESS);
                    return result;
                }
            }
            finally {
                buffer.rLock().unlock();
            }
            this.waitAndSleep(buffer);
            buffer.wLock().lock();
            try {
                segment = buffer.getCurrent();
                value = segment.getValue().getAndIncrement();
                if (value < segment.getMax()) {
                    Result result = new Result(value, Status.SUCCESS);
                    return result;
                }
                if (buffer.isNextReady()) {
                    buffer.switchPos();
                    buffer.setNextReady(false);
                    continue;
                }
                logger.error("Both two segments in {} are not ready!", (Object)buffer);
                Result result = new Result(-3L, Status.EXCEPTION);
                return result;
            }
            finally {
                buffer.wLock().unlock();
                continue;
            }
            break;
        }
    }

    private void waitAndSleep(SegmentBuffer buffer) {
        int roll = 0;
        while (buffer.getThreadRunning().get()) {
            if (++roll <= 10000) continue;
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.warn("Thread {} Interrupted", (Object)Thread.currentThread().getName());
            }
            break;
        }
    }

    public List<LeafAlloc> getAllLeafAllocs() {
        return this.dao.getAllLeafAllocs();
    }

    public Map<String, SegmentBuffer> getCache() {
        return this.cache;
    }

    public IDAllocDao getDao() {
        return this.dao;
    }

    public void setDao(IDAllocDao dao) {
        this.dao = dao;
    }

    public static class UpdateThreadFactory
    implements ThreadFactory {
        private static int threadInitNumber = 0;

        private static synchronized int nextThreadNum() {
            return threadInitNumber++;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Thread-Segment-Update-" + UpdateThreadFactory.nextThreadNum());
        }
    }
}

