/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.inf.leaf.segment.dao.impl;

import com.sankuai.inf.leaf.exception.DbException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.QueryRunner;
import org.h2.jdbcx.JdbcDataSource;

public class DbHelper<T> {
    private final JdbcDataSource dataSource = new JdbcDataSource();
    private final QueryRunner queryRunner = new QueryRunner();

    public DbHelper(String jdbcUrl) {
        this.dataSource.setURL(jdbcUrl);
    }

    public void execute(IExecute execute) throws DbException {
        try {
            Connection connection = this.dataSource.getConnection();
            execute.execute(connection, this.queryRunner);
            connection.close();
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    public T updateAndQuery(IUpdateAndQuery<T> execute) throws DbException {
        try {
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            T res = execute.updateAndQuery(connection, this.queryRunner);
            connection.commit();
            connection.close();
            return res;
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    public int update(IUpdate execute) throws DbException {
        try {
            Connection connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            int res = execute.update(connection, this.queryRunner);
            connection.commit();
            connection.close();
            return res;
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    public T query(IQuery<T> execute) throws DbException {
        try {
            Connection connection = this.dataSource.getConnection();
            T res = execute.query(connection, this.queryRunner);
            connection.close();
            return res;
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    static interface IQuery<T> {
        default public T query(Connection connection, QueryRunner queryRunner) throws SQLException {
            return null;
        }
    }

    static interface IUpdate {
        default public int update(Connection connection, QueryRunner queryRunner) throws SQLException {
            return 0;
        }
    }

    static interface IUpdateAndQuery<T> {
        default public T updateAndQuery(Connection connection, QueryRunner queryRunner) throws SQLException {
            return null;
        }
    }

    static interface IExecute {
        default public void execute(Connection connection, QueryRunner queryRunner) throws SQLException {
        }
    }
}

