/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.inf.leaf.segment.dao.impl;

import com.sankuai.inf.leaf.segment.dao.IDAllocDao;
import com.sankuai.inf.leaf.segment.dao.impl.DbHelper;
import com.sankuai.inf.leaf.segment.model.LeafAlloc;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class IDAllocDaoImpl
implements IDAllocDao {
    private final DbHelper<List<LeafAlloc>> dbHelper;
    private final ResultSetHandler<List<LeafAlloc>> handler = rs -> {
        ArrayList<LeafAlloc> list = new ArrayList<LeafAlloc>();
        while (rs.next()) {
            LeafAlloc leafAlloc = new LeafAlloc();
            leafAlloc.setStep(rs.getInt("STEP"));
            leafAlloc.setKey(rs.getString("TAG"));
            leafAlloc.setMaxId(rs.getInt("MAX_ID"));
            leafAlloc.setUpdateTime(rs.getDate("UPDATE_TIME"));
            list.add(leafAlloc);
        }
        return list;
    };

    public IDAllocDaoImpl(String jdbcUrl) {
        this.dbHelper = new DbHelper(jdbcUrl);
        this.init();
    }

    @Override
    public List<LeafAlloc> getAllLeafAllocs() {
        return this.dbHelper.query(new DbHelper.IQuery<List<LeafAlloc>>(){

            @Override
            public List<LeafAlloc> query(Connection connection, QueryRunner queryRunner) throws SQLException {
                return (List)queryRunner.query(connection, "SELECT * FROM LEAF_ALLOC", IDAllocDaoImpl.this.handler);
            }
        });
    }

    @Override
    public LeafAlloc updateMaxIdAndGetLeafAlloc(final String tag) {
        return this.dbHelper.updateAndQuery(new DbHelper.IUpdateAndQuery<List<LeafAlloc>>(){

            @Override
            public List<LeafAlloc> updateAndQuery(Connection connection, QueryRunner queryRunner) throws SQLException {
                queryRunner.update(connection, "UPDATE LEAF_ALLOC SET MAX_ID = MAX_ID + STEP WHERE TAG = ?", (Object)tag);
                return (List)queryRunner.query(connection, "SELECT * FROM LEAF_ALLOC WHERE TAG = ?", IDAllocDaoImpl.this.handler, new Object[]{tag});
            }
        }).stream().findFirst().orElse(null);
    }

    @Override
    public LeafAlloc updateMaxIdByCustomStepAndGetLeafAlloc(final LeafAlloc leafAlloc) {
        return this.dbHelper.updateAndQuery(new DbHelper.IUpdateAndQuery<List<LeafAlloc>>(){

            @Override
            public List<LeafAlloc> updateAndQuery(Connection connection, QueryRunner queryRunner) throws SQLException {
                queryRunner.update(connection, "UPDATE LEAF_ALLOC SET MAX_ID = MAX_ID + ? WHERE TAG = ?", new Object[]{leafAlloc.getStep(), leafAlloc.getKey()});
                return (List)queryRunner.query(connection, "SELECT * FROM LEAF_ALLOC WHERE TAG = ?", IDAllocDaoImpl.this.handler, new Object[]{leafAlloc.getKey()});
            }
        }).stream().findFirst().orElse(null);
    }

    @Override
    public List<String> getAllTags() {
        return this.getAllLeafAllocs().stream().map(LeafAlloc::getKey).collect(Collectors.toList());
    }

    @Override
    public boolean save(final LeafAlloc leafAlloc) {
        return this.dbHelper.update(new DbHelper.IUpdate(){

            @Override
            public int update(Connection connection, QueryRunner queryRunner) throws SQLException {
                List list = (List)queryRunner.query(connection, "SELECT * FROM LEAF_ALLOC WHERE TAG = ?", IDAllocDaoImpl.this.handler, new Object[]{leafAlloc.getKey()});
                if (list != null && list.size() > 0) {
                    return 0;
                }
                String sql = "INSERT INTO LEAF_ALLOC (MAX_ID, STEP, UPDATE_TIME, TAG) VALUES (?, ?, ?, ?)";
                return queryRunner.update(connection, sql, new Object[]{leafAlloc.getMaxId(), leafAlloc.getStep(), leafAlloc.getUpdateTime(), leafAlloc.getKey()});
            }
        }) > 0;
    }

    private void init() {
        this.dbHelper.execute(new DbHelper.IExecute(){

            @Override
            public void execute(Connection connection, QueryRunner queryRunner) throws SQLException {
                String sql = "CREATE TABLE IF NOT EXISTS LEAF_ALLOC (TAG VARCHAR(128) NOT NULL, MAX_ID BIGINT, STEP INTEGER, UPDATE_TIME TIMESTAMP, PRIMARY KEY (TAG))";
                queryRunner.execute(connection, sql, new Object[0]);
            }
        });
    }
}

