/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.security.configurer;

import com.codingapi.springboot.security.filter.AuthenticationTokenFilter;
import com.codingapi.springboot.security.filter.MyAuthenticationFilter;
import com.codingapi.springboot.security.filter.MyLoginFilter;
import com.codingapi.springboot.security.filter.SecurityLoginHandler;
import com.codingapi.springboot.security.gateway.TokenGateway;
import com.codingapi.springboot.security.properties.CodingApiSecurityProperties;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;

public class HttpSecurityConfigurer
extends AbstractHttpConfigurer<HttpSecurityConfigurer, HttpSecurity> {
    private final TokenGateway tokenGateway;
    private final SecurityLoginHandler securityLoginHandler;
    private final CodingApiSecurityProperties securityProperties;
    private final AuthenticationTokenFilter authenticationTokenFilter;

    public void configure(HttpSecurity security) throws Exception {
        AuthenticationManager manager = (AuthenticationManager)security.getSharedObject(AuthenticationManager.class);
        security.addFilter((Filter)new MyLoginFilter(manager, this.tokenGateway, this.securityLoginHandler, this.securityProperties));
        security.addFilter((Filter)new MyAuthenticationFilter(manager, this.securityProperties, this.tokenGateway, this.authenticationTokenFilter));
    }

    public HttpSecurityConfigurer(TokenGateway tokenGateway, SecurityLoginHandler securityLoginHandler, CodingApiSecurityProperties securityProperties, AuthenticationTokenFilter authenticationTokenFilter) {
        this.tokenGateway = tokenGateway;
        this.securityLoginHandler = securityLoginHandler;
        this.securityProperties = securityProperties;
        this.authenticationTokenFilter = authenticationTokenFilter;
    }
}

