/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.security.gateway;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.springboot.framework.serializable.JsonSerializable;
import com.codingapi.springboot.security.crypto.AESTools;
import com.codingapi.springboot.security.exception.TokenExpiredException;
import com.codingapi.springboot.security.gateway.TokenContext;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class Token
implements JsonSerializable {
    private String username;
    private String extra;
    private String iv;
    private String token;
    private List<String> authorities;
    private long expireTime;
    private long remindTime;

    public Token(String username, String iv, String extra, List<String> authorities, int expireValue, int remindValue) {
        this.username = username;
        this.extra = extra;
        if (iv != null) {
            this.iv = AESTools.getInstance().encode(iv);
        }
        this.authorities = authorities;
        this.expireTime = System.currentTimeMillis() + (long)expireValue;
        this.remindTime = System.currentTimeMillis() + (long)remindValue;
    }

    public void verify() throws TokenExpiredException {
        if (this.isExpire()) {
            throw new TokenExpiredException("token expired.");
        }
    }

    public boolean isExpire() {
        return this.expireTime <= System.currentTimeMillis();
    }

    public String decodeIv() {
        if (this.iv == null) {
            return null;
        }
        return AESTools.getInstance().decode(this.iv);
    }

    public <T> T parseExtra(Class<T> clazz) {
        if (this.extra == null) {
            return null;
        }
        return (T)JSONObject.parseObject((String)this.extra, clazz);
    }

    public boolean canRestToken() {
        return !this.isExpire() && this.remindTime <= System.currentTimeMillis();
    }

    @Transient
    public UsernamePasswordAuthenticationToken getAuthenticationToken() {
        ArrayList<SimpleGrantedAuthority> simpleGrantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        for (String authority : this.authorities) {
            simpleGrantedAuthorities.add(new SimpleGrantedAuthority(authority));
        }
        TokenContext.pushExtra(this.extra);
        return new UsernamePasswordAuthenticationToken((Object)this, (Object)this.iv, simpleGrantedAuthorities);
    }

    public String getUsername() {
        return this.username;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getIv() {
        return this.iv;
    }

    public String getToken() {
        return this.token;
    }

    public List<String> getAuthorities() {
        return this.authorities;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public long getRemindTime() {
        return this.remindTime;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setAuthorities(List<String> authorities) {
        this.authorities = authorities;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public void setRemindTime(long remindTime) {
        this.remindTime = remindTime;
    }

    public Token() {
    }
}

