/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.security.filter;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.springboot.framework.dto.response.Response;
import com.codingapi.springboot.framework.dto.response.SingleResponse;
import com.codingapi.springboot.security.dto.request.LoginRequest;
import com.codingapi.springboot.security.dto.request.LoginRequestContext;
import com.codingapi.springboot.security.dto.response.LoginResponse;
import com.codingapi.springboot.security.filter.SecurityLoginHandler;
import com.codingapi.springboot.security.gateway.Token;
import com.codingapi.springboot.security.gateway.TokenContext;
import com.codingapi.springboot.security.gateway.TokenGateway;
import com.codingapi.springboot.security.properties.CodingApiSecurityProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class MyLoginFilter
extends UsernamePasswordAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(MyLoginFilter.class);
    private final TokenGateway tokenGateway;
    private final SecurityLoginHandler loginHandler;

    public MyLoginFilter(AuthenticationManager authenticationManager, TokenGateway tokenGateway, SecurityLoginHandler loginHandler, CodingApiSecurityProperties securityProperties) {
        super(authenticationManager);
        this.tokenGateway = tokenGateway;
        this.loginHandler = loginHandler;
        this.setRequiresAuthenticationRequestMatcher((RequestMatcher)new AntPathRequestMatcher(securityProperties.getLoginProcessingUrl(), "POST"));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        log.debug("login authentication ~");
        String content = null;
        try {
            content = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new AuthenticationServiceException("request input stream read fail.");
        }
        LoginRequest login = (LoginRequest)JSONObject.parseObject((String)content, LoginRequest.class);
        if (login == null || login.isEmpty()) {
            throw new AuthenticationServiceException("request stream read was null.");
        }
        try {
            this.loginHandler.preHandle(request, response, login);
        }
        catch (Exception e) {
            throw new AuthenticationServiceException(e.getLocalizedMessage());
        }
        LoginRequestContext.getInstance().set(login);
        return this.getAuthenticationManager().authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)login.getUsername(), (Object)login.getPassword()));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        log.debug("login success authentication ~");
        UserDetails user = (UserDetails)authResult.getPrincipal();
        LoginRequest loginRequest = LoginRequestContext.getInstance().get();
        Token token = this.tokenGateway.create(user.getUsername(), loginRequest.getPassword(), user.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList()), TokenContext.getExtra());
        LoginResponse loginResponse = this.loginHandler.postHandle(request, response, loginRequest, user, token);
        String content = JSONObject.toJSONString((Object)SingleResponse.of((Object)loginResponse));
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        IOUtils.write((String)content, (OutputStream)response.getOutputStream(), (Charset)StandardCharsets.UTF_8);
        LoginRequestContext.getInstance().clean();
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        log.debug("login fail authentication ~");
        String content = JSONObject.toJSONString((Object)Response.buildFailure((String)"login.error", (String)failed.getMessage()));
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        IOUtils.write((String)content, (OutputStream)response.getOutputStream(), (Charset)StandardCharsets.UTF_8);
        LoginRequestContext.getInstance().clean();
    }
}

