/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.security.jwt;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.springboot.framework.exception.LocaleMessageException;
import com.codingapi.springboot.security.gateway.Token;
import com.codingapi.springboot.security.jwt.SecurityJWTProperties;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.List;
import javax.crypto.SecretKey;

public class JwtTokenGateway {
    private final SecretKey key;
    private final int validTime;
    private final int restTime;

    public JwtTokenGateway(SecurityJWTProperties properties) {
        this.key = Keys.hmacShaKeyFor((byte[])properties.getSecretKey().getBytes(StandardCharsets.UTF_8));
        this.validTime = properties.getValidTime();
        this.restTime = properties.getRestTime();
    }

    public Token create(String username, List<String> authorities, String extra) {
        return this.create(username, null, authorities, extra);
    }

    public Token create(String username, List<String> authorities) {
        return this.create(username, null, authorities, null);
    }

    public Token create(String username, String iv, List<String> authorities) {
        return this.create(username, iv, authorities, null);
    }

    public Token create(String username, String iv, List<String> authorities, String extra) {
        Token token = new Token(username, iv, extra, authorities, this.validTime, this.restTime);
        String jwt = Jwts.builder().subject(token.toJson()).signWith((Key)this.key).compact();
        token.setToken(jwt);
        return token;
    }

    public Token parser(String sign) {
        try {
            Jws jws = Jwts.parser().verifyWith(this.key).build().parseSignedClaims((CharSequence)sign);
            if (jws != null) {
                String subject = ((Claims)jws.getPayload()).getSubject();
                return (Token)JSONObject.parseObject((String)subject, Token.class);
            }
            throw new LocaleMessageException("token.error", "token\u5931\u6548,\u8bf7\u91cd\u65b0\u767b\u5f55.");
        }
        catch (Exception exp) {
            throw new LocaleMessageException("token.error", exp.getMessage());
        }
    }
}

