/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.security.filter;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.springboot.framework.dto.response.Response;
import com.codingapi.springboot.security.exception.TokenExpiredException;
import com.codingapi.springboot.security.filter.AuthenticationTokenFilter;
import com.codingapi.springboot.security.gateway.Token;
import com.codingapi.springboot.security.gateway.TokenGateway;
import com.codingapi.springboot.security.properties.CodingApiSecurityProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class MyAuthenticationFilter
extends BasicAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(MyAuthenticationFilter.class);
    private static final String TOKEN_KEY = "Authorization";
    private final TokenGateway tokenGateway;
    private final CodingApiSecurityProperties securityProperties;
    private final AuthenticationTokenFilter authenticationTokenFilter;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public MyAuthenticationFilter(AuthenticationManager manager, CodingApiSecurityProperties securityProperties, TokenGateway tokenGateway, AuthenticationTokenFilter authenticationTokenFilter) {
        super(manager);
        this.tokenGateway = tokenGateway;
        this.securityProperties = securityProperties;
        this.authenticationTokenFilter = authenticationTokenFilter;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("token authentication ~");
        for (String antUrl : this.securityProperties.getAuthenticatedUrls()) {
            if (!this.antPathMatcher.match(antUrl, request.getRequestURI())) continue;
            String sign = request.getHeader(TOKEN_KEY);
            if (!StringUtils.hasLength((String)sign)) {
                this.writeResponse(response, Response.buildFailure((String)"token.error", (String)"token must not null."));
                return;
            }
            Token token = this.tokenGateway.parser(sign);
            if (token.canRestToken()) {
                Token newSign = this.tokenGateway.create(token.getUsername(), token.decodeIv(), token.getAuthorities(), token.getExtra());
                log.info("reset token ");
                response.setHeader(TOKEN_KEY, newSign.getToken());
            }
            try {
                token.verify();
            }
            catch (TokenExpiredException e) {
                this.writeResponse(response, Response.buildFailure((String)"token.expire", (String)"token expire."));
                return;
            }
            SecurityContextHolder.getContext().setAuthentication((Authentication)token.getAuthenticationToken());
            this.authenticationTokenFilter.doFilter(request, response);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void writeResponse(HttpServletResponse servletResponse, Response returnResponse) throws IOException {
        String content = JSONObject.toJSONString((Object)returnResponse);
        servletResponse.setContentType("application/json;charset=UTF-8");
        servletResponse.setCharacterEncoding("UTF-8");
        IOUtils.write((String)content, (OutputStream)servletResponse.getOutputStream(), (Charset)StandardCharsets.UTF_8);
    }
}

