/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.security.customer;

import com.codingapi.springboot.security.customer.HttpSecurityCustomer;
import com.codingapi.springboot.security.properties.CodingApiSecurityProperties;
import lombok.Generated;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;

public class DefaultHttpSecurityCustomer
implements HttpSecurityCustomer {
    private final CodingApiSecurityProperties properties;

    @Override
    public void customize(HttpSecurity security) throws Exception {
        if (this.properties.isDisableBasicAuth()) {
            security.httpBasic(AbstractHttpConfigurer::disable);
        }
        if (this.properties.isDisableFrameOptions()) {
            security.headers((Customizer)new Customizer<HeadersConfigurer<HttpSecurity>>(){

                public void customize(HeadersConfigurer<HttpSecurity> httpSecurityHeadersConfigurer) {
                    httpSecurityHeadersConfigurer.frameOptions((Customizer)new Customizer<HeadersConfigurer.FrameOptionsConfig>(){

                        public void customize(HeadersConfigurer.FrameOptionsConfig frameOptionsConfig) {
                            frameOptionsConfig.disable();
                        }
                    });
                }
            });
        }
        security.cors(httpSecurityCorsConfigurer -> {
            if (this.properties.isDisableCors()) {
                httpSecurityCorsConfigurer.disable();
            }
        });
        security.csrf(httpSecurityCsrfConfigurer -> {
            if (this.properties.isDisableCsrf()) {
                httpSecurityCsrfConfigurer.disable();
            }
        });
    }

    @Generated
    public DefaultHttpSecurityCustomer(CodingApiSecurityProperties properties) {
        this.properties = properties;
    }
}

