/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.crypto;

import com.codingapi.springboot.framework.crypto.AESUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.util.Base64Utils;

public class AES {
    private final SecretKeySpec key;
    private final IvParameterSpec iv;
    private final Properties properties;
    private final String transform;

    public AES(String key, String iv) {
        this.key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
        this.iv = new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8));
        this.properties = new Properties();
        this.transform = "AES/CBC/PKCS5Padding";
        AESUtils.getInstance().init(this);
    }

    public String encodeToBase64(String input) throws IOException {
        return Base64Utils.encodeToString((byte[])this.encode(input.getBytes(StandardCharsets.UTF_8)));
    }

    public String decodeToBase64(String input) throws IOException {
        return new String(this.decode(Base64Utils.decodeFromString((String)input)), StandardCharsets.UTF_8);
    }

    public byte[] encode(byte[] input) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (CryptoOutputStream cos = new CryptoOutputStream(this.transform, this.properties, (OutputStream)outputStream, (Key)this.key, (AlgorithmParameterSpec)this.iv);){
            cos.write(input);
            cos.flush();
        }
        return outputStream.toByteArray();
    }

    public byte[] decode(byte[] input) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        try (CryptoInputStream cis = new CryptoInputStream(this.transform, this.properties, (InputStream)inputStream, (Key)this.key, (AlgorithmParameterSpec)this.iv);){
            byte[] byArray = IOUtils.toByteArray((InputStream)cis);
            return byArray;
        }
    }
}

