/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.response;

import com.codingapi.springboot.framework.dto.response.Response;
import java.util.Collection;
import org.springframework.data.domain.Page;

public class MultiResponse<T>
extends Response {
    private long total;
    private Collection<T> data;

    public static <T> MultiResponse<T> of(Collection<T> data, long total) {
        MultiResponse<T> multiResponse = new MultiResponse<T>();
        multiResponse.setSuccess(true);
        multiResponse.setData(data);
        multiResponse.setTotal(total);
        return multiResponse;
    }

    public static <T> MultiResponse<T> of(Page<T> page) {
        return MultiResponse.of(page.getContent(), page.getTotalElements());
    }

    public static <T> MultiResponse<T> empty() {
        MultiResponse<T> multiResponse = new MultiResponse<T>();
        multiResponse.setSuccess(true);
        multiResponse.setData(null);
        multiResponse.setTotal(0L);
        return multiResponse;
    }

    public static <T> MultiResponse<T> of(Collection<T> data) {
        MultiResponse<T> multiResponse = new MultiResponse<T>();
        multiResponse.setSuccess(true);
        multiResponse.setData(data);
        long total = 0L;
        if (data != null) {
            total = data.size();
        }
        multiResponse.setTotal(total);
        return multiResponse;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setData(Collection<T> data) {
        this.data = data;
    }

    public long getTotal() {
        return this.total;
    }

    public Collection<T> getData() {
        return this.data;
    }
}

