/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.event;

import com.codingapi.springboot.framework.event.DomainEvent;
import com.codingapi.springboot.framework.event.IAsyncEvent;
import com.codingapi.springboot.framework.event.IEvent;
import com.codingapi.springboot.framework.event.ISyncEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

class DomainEventContext {
    private static DomainEventContext instance;
    private ApplicationContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomainEventContext getInstance() {
        if (instance != null) return instance;
        Class<DomainEventContext> clazz = DomainEventContext.class;
        synchronized (DomainEventContext.class) {
            if (instance != null) return instance;
            instance = new DomainEventContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DomainEventContext() {
    }

    private void push(IEvent event, boolean sync) {
        if (this.context != null) {
            this.context.publishEvent((ApplicationEvent)new DomainEvent(event, sync));
        }
    }

    public void push(IEvent event) {
        if (event instanceof IAsyncEvent) {
            this.push(event, false);
        } else if (event instanceof ISyncEvent) {
            this.push(event, true);
        } else {
            this.push(event, true);
        }
    }

    protected void initContext(ApplicationContext context) {
        this.context = context;
    }
}

