/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.handler;

import com.codingapi.springboot.framework.handler.Handler;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@Configuration
public class HandlerBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(HandlerBeanDefinitionRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(SpringBootApplication.class.getName());
        if (attributes == null) {
            return;
        }
        String defaultPackage = Class.forName(importingClassMetadata.getClassName()).getPackage().getName();
        log.debug("defaultPackage:{}", (Object)defaultPackage);
        ClassPathScanningCandidateComponentProvider pathScanningCandidateComponentProvider = new ClassPathScanningCandidateComponentProvider(false);
        pathScanningCandidateComponentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Handler.class));
        LinkedHashSet candidateComponents = new LinkedHashSet();
        String[] scanBasePackages = (String[])attributes.getOrDefault("scanBasePackages", Collections.singletonList(defaultPackage));
        for (String basePackages : scanBasePackages) {
            candidateComponents.addAll(pathScanningCandidateComponentProvider.findCandidateComponents(basePackages));
        }
        log.debug("candidateComponents:{}", candidateComponents);
        for (BeanDefinition candidateComponent : candidateComponents) {
            String beanName = candidateComponent.getBeanClassName();
            registry.registerBeanDefinition(beanName, candidateComponent);
        }
    }
}

