/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.codingapi.springboot.framework.rest.HttpClient;
import com.codingapi.springboot.framework.rest.param.ApiGetParamBuilder;
import com.codingapi.springboot.framework.rest.param.ApiPostParamBuilder;
import com.codingapi.springboot.framework.rest.properties.RestApiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private final HttpClient httpClient;
    private static final int RETRY_COUNT = 5;
    private static final String EMPTY = "{}";

    public RestClient(RestApiProperties restApiProperties, String baseUrl) {
        this.httpClient = new HttpClient(restApiProperties, baseUrl);
    }

    public RestClient(String baseUrl) {
        this.httpClient = new HttpClient(null, baseUrl);
    }

    private String _get(String api, ApiGetParamBuilder paramBuilder) {
        return this.httpClient.get(api, paramBuilder != null ? paramBuilder.build() : null);
    }

    public String get(String api, ApiGetParamBuilder paramBuilder) {
        for (int i = 0; i < 5; ++i) {
            try {
                return this._get(api, paramBuilder);
            }
            catch (Exception e) {
                log.warn("api:{},error:{}", (Object)api, (Object)e.getMessage());
                this.sleep();
                continue;
            }
        }
        return EMPTY;
    }

    public String get(String api) {
        return this.get(api, null);
    }

    private String _post(String api, ApiPostParamBuilder paramBuilder) {
        return this._post(api, paramBuilder.build());
    }

    private String _post(String api, JSONObject requestBody) {
        return this.httpClient.post(api, (JSON)requestBody);
    }

    public String post(String api, JSONObject requestBody) {
        for (int i = 0; i < 5; ++i) {
            try {
                return this._post(api, requestBody);
            }
            catch (Exception e) {
                log.warn("api:{},error:{}", (Object)api, (Object)e.getMessage());
                this.sleep();
                continue;
            }
        }
        return EMPTY;
    }

    public String post(String api, ApiPostParamBuilder paramBuilder) {
        for (int i = 0; i < 5; ++i) {
            try {
                return this._post(api, paramBuilder);
            }
            catch (Exception e) {
                log.warn("api:{},error:{}", (Object)api, (Object)e.getMessage());
                this.sleep();
                continue;
            }
        }
        return EMPTY;
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

