/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.crypto;

import com.codingapi.springboot.framework.crypto.RSAUtils;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import org.bouncycastle.util.encoders.Base64;

public class RSA {
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    public RSA() throws NoSuchAlgorithmException {
        KeyPair keyPair = RSAUtils.generateKey();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    public RSA(PrivateKey privateKey, PublicKey publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public RSA(String privateKey, String publicKey) throws Exception {
        this.privateKey = RSAUtils.getPrivateKeyFromString(privateKey);
        this.publicKey = RSAUtils.getPublicKeyFromString(publicKey);
    }

    public byte[] encrypt(byte[] text) throws Exception {
        byte[] cipherText = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, this.publicKey);
        cipherText = cipher.doFinal(text);
        return cipherText;
    }

    public String encrypt(String text) throws Exception {
        byte[] cipherText = this.encrypt(text.getBytes(StandardCharsets.UTF_8));
        String encryptedText = Base64.toBase64String((byte[])cipherText);
        return encryptedText;
    }

    public byte[] decrypt(byte[] text) throws Exception {
        byte[] dectyptedText = null;
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, this.privateKey);
        dectyptedText = cipher.doFinal(text);
        return dectyptedText;
    }

    public String decrypt(String text) throws Exception {
        byte[] dectyptedText = this.decrypt(Base64.decode((String)text));
        String result = new String(dectyptedText, StandardCharsets.UTF_8);
        return result;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

