/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.crypto;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class RSAUtils {
    protected static final String ALGORITHM = "RSA";

    private RSAUtils() {
    }

    public static KeyPair generateKey() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
        keyGen.initialize(2048);
        return keyGen.generateKeyPair();
    }

    public static PrivateKey getPrivateKeyFromString(String key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(Base64.decode((String)key));
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static PublicKey getPublicKeyFromString(String key) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decode((String)key));
        return keyFactory.generatePublic(publicKeySpec);
    }

    public static String getKeyAsString(Key key) {
        byte[] keyBytes = key.getEncoded();
        return Base64.toBase64String((byte[])keyBytes);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

