/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.dto.request;

import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageRequest
extends org.springframework.data.domain.PageRequest {
    public static final String CURRENT_FIX_VALUE = "CURRENT_FIX_VALUE";
    private int current;
    private int pageSize;
    private org.springframework.data.domain.PageRequest pageRequest;

    public PageRequest(int current, int pageSize, Sort sort) {
        super(current, pageSize, sort);
        this.current = current;
        this.pageSize = pageSize;
        this.pageRequest = PageRequest.of(current, pageSize, sort);
    }

    public PageRequest() {
        this(0, 20, Sort.unsorted());
    }

    public static org.springframework.data.domain.PageRequest of(int page, int size) {
        return org.springframework.data.domain.PageRequest.of((int)page, (int)size);
    }

    public static org.springframework.data.domain.PageRequest of(int page, int size, Sort sort) {
        return org.springframework.data.domain.PageRequest.of((int)page, (int)size, (Sort)sort);
    }

    public static org.springframework.data.domain.PageRequest of(int page, int size, Sort.Direction direction, String ... properties) {
        return org.springframework.data.domain.PageRequest.of((int)page, (int)size, (Sort.Direction)direction, (String[])properties);
    }

    public static org.springframework.data.domain.PageRequest ofSize(int pageSize) {
        return org.springframework.data.domain.PageRequest.ofSize((int)pageSize);
    }

    public static Pageable unpaged() {
        return Pageable.unpaged();
    }

    private void initPage() {
        int fixValue = 0;
        try {
            fixValue = Integer.parseInt(System.getProperty(CURRENT_FIX_VALUE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pageRequest = PageRequest.of(this.current - fixValue, this.pageSize, this.pageRequest.getSort());
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        this.current = current;
        this.initPage();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.initPage();
    }

    public Sort getSort() {
        return this.pageRequest.getSort();
    }

    public org.springframework.data.domain.PageRequest next() {
        return this.pageRequest.next();
    }

    public org.springframework.data.domain.PageRequest previous() {
        return this.pageRequest.previous();
    }

    public org.springframework.data.domain.PageRequest first() {
        return this.pageRequest.first();
    }

    public boolean equals(Object obj) {
        return this.pageRequest.equals(obj);
    }

    public org.springframework.data.domain.PageRequest withPage(int pageNumber) {
        return this.pageRequest.withPage(pageNumber);
    }

    public org.springframework.data.domain.PageRequest withSort(Sort.Direction direction, String ... properties) {
        return this.pageRequest.withSort(direction, properties);
    }

    public org.springframework.data.domain.PageRequest withSort(Sort sort) {
        return this.pageRequest.withSort(sort);
    }

    public int hashCode() {
        return this.pageRequest.hashCode();
    }

    public String toString() {
        return this.pageRequest.toString();
    }

    public int getPageNumber() {
        return this.pageRequest.getPageNumber();
    }

    public long getOffset() {
        return this.pageRequest.getOffset();
    }

    public boolean hasPrevious() {
        return this.pageRequest.hasPrevious();
    }

    public Pageable previousOrFirst() {
        return this.pageRequest.previousOrFirst();
    }

    public boolean isPaged() {
        return this.pageRequest.isPaged();
    }

    public boolean isUnpaged() {
        return this.pageRequest.isUnpaged();
    }

    public Sort getSortOr(Sort sort) {
        return this.pageRequest.getSortOr(sort);
    }

    public Optional<Pageable> toOptional() {
        return this.pageRequest.toOptional();
    }
}

