/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.springboot.framework.registrar;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.util.AnnotatedTypeScanner;

public class RegisterBeanScanner {
    private static final Logger log = LoggerFactory.getLogger(RegisterBeanScanner.class);
    private final AnnotationMetadata importingClassMetadata;
    private final Class<? extends Annotation> handlerClass;
    private final List<String> scannerPackageNames;

    public RegisterBeanScanner(AnnotationMetadata importingClassMetadata, Class<? extends Annotation> handlerClass) throws ClassNotFoundException {
        this.importingClassMetadata = importingClassMetadata;
        this.handlerClass = handlerClass;
        this.scannerPackageNames = new ArrayList<String>();
        this.loadScannerPackages();
    }

    private void loadScannerPackages() throws ClassNotFoundException {
        Map attributes = this.importingClassMetadata.getAnnotationAttributes(SpringBootApplication.class.getName());
        if (attributes == null) {
            return;
        }
        String defaultPackage = Class.forName(this.importingClassMetadata.getClassName()).getPackage().getName();
        this.addPackage(defaultPackage);
        String[] scanBasePackages = (String[])attributes.get("scanBasePackages");
        if (scanBasePackages != null) {
            for (String basePackages : scanBasePackages) {
                this.addPackage(basePackages);
            }
        }
        log.debug("scannerPackageNames:{}", this.scannerPackageNames);
    }

    public List<BeanDefinition> findBeanDefinitions() {
        ClassPathScanningCandidateComponentProvider pathScanningCandidateComponentProvider = new ClassPathScanningCandidateComponentProvider(false);
        pathScanningCandidateComponentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.handlerClass, true, true));
        ArrayList<BeanDefinition> candidateComponents = new ArrayList<BeanDefinition>();
        for (String packageName : this.scannerPackageNames) {
            candidateComponents.addAll(pathScanningCandidateComponentProvider.findCandidateComponents(packageName));
        }
        return candidateComponents;
    }

    public Set<Class<?>> findTypes() {
        AnnotatedTypeScanner annotatedTypeScanner = new AnnotatedTypeScanner(new Class[]{this.handlerClass});
        return annotatedTypeScanner.findTypes(this.scannerPackageNames);
    }

    private String appendPackageChildren(String packageName) {
        if (!packageName.endsWith(".*") || !packageName.endsWith(".**")) {
            packageName = String.format("%s.**", packageName);
        }
        return packageName;
    }

    private void addPackage(String packageName) {
        if (packageName != null) {
            this.scannerPackageNames.add(this.appendPackageChildren(packageName));
        }
    }
}

